/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.richfaces;

import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.context.AjaxContext;
import org.springframework.faces.webflow.FacesContextHelper;
import org.springframework.js.ajax.AbstractAjaxHandler;
import org.springframework.js.ajax.AjaxHandler;

public class RichFacesAjaxHandler
extends AbstractAjaxHandler
implements AjaxHandler {
    public RichFacesAjaxHandler() {
        this(null);
    }

    public RichFacesAjaxHandler(AbstractAjaxHandler delegate) {
        super(delegate);
    }

    protected boolean isAjaxRequestInternal(HttpServletRequest request, HttpServletResponse response) {
        FacesContextHelper helper = new FacesContextHelper();
        try {
            FacesContext facesContext = helper.getFacesContext(this.getServletContext(), request, response);
            AjaxContext context = AjaxContext.getCurrentInstance((FacesContext)facesContext);
            if (context != null) {
                boolean bl = context.isAjaxRequest(facesContext);
                return bl;
            }
            return false;
        }
        finally {
            helper.releaseIfNecessary();
        }
    }

    protected void sendAjaxRedirectInternal(String targetUrl, HttpServletRequest request, HttpServletResponse response, boolean popup) throws IOException {
        response.sendRedirect(response.encodeRedirectURL(targetUrl));
    }
}

