/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.ognl;

import java.lang.reflect.Member;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ognl.NoSuchPropertyException;
import ognl.Ognl;
import ognl.OgnlException;
import ognl.TypeConverter;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.binding.convert.ConversionException;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.PropertyNotFoundException;
import org.springframework.binding.expression.ValueCoercionException;

class OgnlExpression
implements Expression {
    private Object expression;
    private Map<String, Expression> variableExpressions;
    private Class<?> expectedResultType;
    private String expressionString;
    private ConversionService conversionService;

    public OgnlExpression(Object expression, Map<String, Expression> variableExpressions, Class<?> expectedResultType, String expressionString, ConversionService conversionService) {
        this.expression = expression;
        this.variableExpressions = variableExpressions;
        this.expectedResultType = expectedResultType;
        this.expressionString = expressionString;
        this.conversionService = conversionService;
    }

    public boolean equals(Object o) {
        if (!(o instanceof OgnlExpression)) {
            return false;
        }
        OgnlExpression other = (OgnlExpression)o;
        return this.expressionString.equals(other.expressionString);
    }

    public int hashCode() {
        return this.expressionString.hashCode();
    }

    @Override
    public Object getValue(Object context) throws EvaluationException {
        try {
            Map evaluationContext = Ognl.addDefaultContext((Object)context, this.getVariables(context));
            Ognl.setTypeConverter((Map)evaluationContext, (TypeConverter)this.createTypeConverter());
            return Ognl.getValue((Object)this.expression, (Map)evaluationContext, (Object)context, this.expectedResultType);
        }
        catch (NoSuchPropertyException e) {
            throw new PropertyNotFoundException(context.getClass(), this.getExpressionString(), e);
        }
        catch (OgnlException e) {
            if (e.getReason() instanceof ValueCoercionException) {
                throw (ValueCoercionException)e.getReason();
            }
            throw new EvaluationException(context.getClass(), this.getExpressionString(), "An OgnlException occurred getting the value for expression '" + this.getExpressionString() + "' on context [" + context.getClass() + "]", this.causeFor(e));
        }
    }

    @Override
    public void setValue(Object context, Object value) {
        try {
            Map evaluationContext = Ognl.addDefaultContext((Object)context, this.getVariables(context));
            Ognl.setTypeConverter((Map)evaluationContext, (TypeConverter)this.createTypeConverter());
            Ognl.setValue((Object)this.expression, (Map)evaluationContext, (Object)context, (Object)value);
        }
        catch (NoSuchPropertyException e) {
            throw new PropertyNotFoundException(context.getClass(), this.getExpressionString(), e);
        }
        catch (OgnlException e) {
            if (e.getReason() instanceof ValueCoercionException) {
                throw (ValueCoercionException)e.getReason();
            }
            throw new EvaluationException(context.getClass(), this.getExpressionString(), "An OgnlException occurred setting the value of expression '" + this.getExpressionString() + "' on context [" + context.getClass() + "] to [" + value + "]", this.causeFor(e));
        }
    }

    @Override
    public Class<?> getValueType(Object context) {
        try {
            return new BeanWrapperImpl(context).getPropertyType(this.expressionString);
        }
        catch (InvalidPropertyException e) {
            throw new PropertyNotFoundException(context.getClass(), this.getExpressionString(), e);
        }
        catch (BeansException e) {
            throw new EvaluationException(context.getClass(), this.getExpressionString(), "An BeansException occurred getting the value type for expression '" + this.getExpressionString() + "' on context [" + context.getClass() + "]", e);
        }
    }

    @Override
    public String getExpressionString() {
        return this.expressionString;
    }

    private Throwable causeFor(OgnlException e) {
        if (e.getReason() != null) {
            if (e.getCause() == null) {
                try {
                    e.initCause(e.getReason());
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            return e;
        }
        return e;
    }

    private TypeConverter createTypeConverter() {
        return new TypeConverter(){

            public Object convertValue(Map context, Object target, Member member, String propertyName, Object value, Class toType) throws ValueCoercionException {
                try {
                    return OgnlExpression.this.conversionService.executeConversion(value, toType);
                }
                catch (ConversionException e) {
                    throw new ValueCoercionException(context.getClass(), OgnlExpression.this.expressionString, value, toType, e);
                }
            }
        };
    }

    private Map<String, Object> getVariables(Object context) {
        if (this.variableExpressions == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> variables = new HashMap<String, Object>(this.variableExpressions.size(), 1.0f);
        for (Map.Entry<String, Expression> var : this.variableExpressions.entrySet()) {
            Expression valueExpression = var.getValue();
            variables.put(var.getKey(), valueExpression.getValue(context));
        }
        return variables;
    }

    public String toString() {
        return this.expressionString;
    }
}

