/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.boot.support;

import java.util.HashMap;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.monitor.AbstractStateMachineMonitor;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.transition.Transition;
import org.springframework.util.ObjectUtils;

public class BootStateMachineMonitor<S, E>
extends AbstractStateMachineMonitor<S, E> {
    private final String METRIC_TRANSITION_BASE = "ssm.transition";
    private final String METRIC_ACTION_BASE = "ssm.action";
    private final CounterService counterService;
    private final GaugeService gaugeService;
    private final TraceRepository traceRepository;

    public BootStateMachineMonitor(CounterService counterService, GaugeService gaugeService, TraceRepository traceRepository) {
        this.counterService = counterService;
        this.gaugeService = gaugeService;
        this.traceRepository = traceRepository;
    }

    public void transition(StateMachine<S, E> stateMachine, Transition<S, E> transition, long duration) {
        String transitionName = BootStateMachineMonitor.transitionToName(transition);
        this.counterService.increment("ssm.transition." + transitionName + ".transit");
        this.gaugeService.submit("ssm.transition." + transitionName + ".duration", (double)duration);
        HashMap<String, Object> traceInfo = new HashMap<String, Object>();
        traceInfo.put("transition", BootStateMachineMonitor.transitionToName(transition));
        traceInfo.put("duration", duration);
        traceInfo.put("machine", stateMachine.getId());
        this.traceRepository.add(traceInfo);
    }

    public void action(StateMachine<S, E> stateMachine, Action<S, E> action, long duration) {
        String actionName = BootStateMachineMonitor.actionToName(action);
        this.counterService.increment("ssm.action." + actionName + ".execute");
        this.gaugeService.submit("ssm.action." + actionName + ".duration", (double)duration);
        HashMap<String, Object> traceInfo = new HashMap<String, Object>();
        traceInfo.put("action", actionName);
        traceInfo.put("duration", duration);
        traceInfo.put("machine", stateMachine.getId());
        this.traceRepository.add(traceInfo);
    }

    private static <S, E> String transitionToName(Transition<S, E> transition) {
        String sourceId = BootStateMachineMonitor.nullStateId(transition.getSource());
        String targetId = BootStateMachineMonitor.nullStateId(transition.getTarget());
        StringBuilder buf = new StringBuilder();
        buf.append(transition.getKind());
        if (sourceId != null) {
            buf.append("_");
            buf.append(sourceId);
        }
        if (targetId != null) {
            buf.append("_");
            buf.append(targetId);
        }
        return buf.toString();
    }

    private static <S, E> String actionToName(Action<S, E> action) {
        return ObjectUtils.getDisplayString(action);
    }

    private static <S, E> String nullStateId(State<S, E> state) {
        if (state == null) {
            return null;
        }
        Object id = state.getId();
        return id != null ? id.toString() : null;
    }
}

