/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.web.socket.WebSocketExtension;

public class WebSocketHttpHeaders
extends HttpHeaders {
    public static final String SEC_WEBSOCKET_ACCEPT = "Sec-WebSocket-Accept";
    public static final String SEC_WEBSOCKET_EXTENSIONS = "Sec-WebSocket-Extensions";
    public static final String SEC_WEBSOCKET_KEY = "Sec-WebSocket-Key";
    public static final String SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
    public static final String SEC_WEBSOCKET_VERSION = "Sec-WebSocket-Version";
    private static final long serialVersionUID = -6644521016187828916L;
    private final HttpHeaders headers;

    public WebSocketHttpHeaders() {
        this(new HttpHeaders());
    }

    public WebSocketHttpHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public void setSecWebSocketAccept(@Nullable String secWebSocketAccept) {
        this.set(SEC_WEBSOCKET_ACCEPT, secWebSocketAccept);
    }

    public @Nullable String getSecWebSocketAccept() {
        return this.getFirst(SEC_WEBSOCKET_ACCEPT);
    }

    public List<WebSocketExtension> getSecWebSocketExtensions() {
        List<String> values = this.get(SEC_WEBSOCKET_EXTENSIONS);
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyList();
        }
        ArrayList<WebSocketExtension> result = new ArrayList<WebSocketExtension>(values.size());
        for (String value : values) {
            result.addAll(WebSocketExtension.parseExtensions(value));
        }
        return result;
    }

    public void setSecWebSocketExtensions(List<WebSocketExtension> extensions) {
        ArrayList<String> result = new ArrayList<String>(extensions.size());
        for (WebSocketExtension extension : extensions) {
            result.add(extension.toString());
        }
        this.set(SEC_WEBSOCKET_EXTENSIONS, this.toCommaDelimitedString(result));
    }

    public void setSecWebSocketKey(@Nullable String secWebSocketKey) {
        this.set(SEC_WEBSOCKET_KEY, secWebSocketKey);
    }

    public @Nullable String getSecWebSocketKey() {
        return this.getFirst(SEC_WEBSOCKET_KEY);
    }

    public void setSecWebSocketProtocol(String secWebSocketProtocol) {
        this.set(SEC_WEBSOCKET_PROTOCOL, secWebSocketProtocol);
    }

    public void setSecWebSocketProtocol(List<String> secWebSocketProtocols) {
        this.set(SEC_WEBSOCKET_PROTOCOL, this.toCommaDelimitedString(secWebSocketProtocols));
    }

    public List<String> getSecWebSocketProtocol() {
        List<String> values = this.get(SEC_WEBSOCKET_PROTOCOL);
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyList();
        }
        if (values.size() == 1) {
            return this.getValuesAsList(SEC_WEBSOCKET_PROTOCOL);
        }
        return values;
    }

    public void setSecWebSocketVersion(@Nullable String secWebSocketVersion) {
        this.set(SEC_WEBSOCKET_VERSION, secWebSocketVersion);
    }

    public @Nullable String getSecWebSocketVersion() {
        return this.getFirst(SEC_WEBSOCKET_VERSION);
    }

    public @Nullable String getFirst(String headerName) {
        return this.headers.getFirst(headerName);
    }

    public void add(String headerName, @Nullable String headerValue) {
        this.headers.add(headerName, headerValue);
    }

    public void set(String headerName, @Nullable String headerValue) {
        this.headers.set(headerName, headerValue);
    }

    public void setAll(Map<String, String> values) {
        this.headers.setAll(values);
    }

    public Map<String, String> toSingleValueMap() {
        return this.headers.toSingleValueMap();
    }

    public int size() {
        return this.headers.size();
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public boolean containsHeader(String key) {
        return this.headers.containsHeader(key);
    }

    public @Nullable List<String> get(String headerName) {
        return this.headers.get(headerName);
    }

    public @Nullable List<String> put(String key, List<String> value) {
        return this.headers.put(key, value);
    }

    public @Nullable List<String> remove(String key) {
        return this.headers.remove(key);
    }

    public void putAll(HttpHeaders headers) {
        this.headers.putAll(headers);
    }

    public void putAll(Map<? extends String, ? extends List<String>> m) {
        this.headers.putAll(m);
    }

    public void clear() {
        this.headers.clear();
    }

    public Set<String> headerNames() {
        return this.headers.headerNames();
    }

    public Set<Map.Entry<String, List<String>>> headerSet() {
        return this.headers.headerSet();
    }

    public void forEach(BiConsumer<? super String, ? super List<String>> action) {
        this.headers.forEach(action);
    }

    public @Nullable List<String> putIfAbsent(String headerName, List<String> headerValues) {
        return this.headers.putIfAbsent(headerName, headerValues);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof WebSocketHttpHeaders)) return false;
        WebSocketHttpHeaders that = (WebSocketHttpHeaders)((Object)other);
        if (!this.headers.equals((Object)that.headers)) return false;
        return true;
    }

    public int hashCode() {
        return this.headers.hashCode();
    }

    public String toString() {
        return this.headers.toString();
    }
}

