/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.standard;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.websocket.Extension;
import jakarta.websocket.WebSocketContainer;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpointConfig;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.adapter.standard.StandardToWebSocketExtensionAdapter;
import org.springframework.web.socket.adapter.standard.StandardWebSocketHandlerAdapter;
import org.springframework.web.socket.adapter.standard.StandardWebSocketSession;
import org.springframework.web.socket.adapter.standard.WebSocketToStandardExtensionAdapter;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.RequestUpgradeStrategy;
import org.springframework.web.socket.server.standard.ServerEndpointRegistration;

public class StandardWebSocketUpgradeStrategy
implements RequestUpgradeStrategy {
    private static final String[] SUPPORTED_VERSIONS = new String[]{"13"};
    private volatile @Nullable List<WebSocketExtension> extensions;

    @Override
    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    @Override
    public List<WebSocketExtension> getSupportedExtensions(ServerHttpRequest request) {
        List<WebSocketExtension> extensions = this.extensions;
        if (extensions == null) {
            HttpServletRequest servletRequest = ((ServletServerHttpRequest)request).getServletRequest();
            this.extensions = extensions = this.getInstalledExtensions((WebSocketContainer)this.getContainer(servletRequest));
        }
        return extensions;
    }

    protected List<WebSocketExtension> getInstalledExtensions(WebSocketContainer container) {
        ArrayList<WebSocketExtension> result = new ArrayList<WebSocketExtension>();
        for (Extension extension : container.getInstalledExtensions()) {
            result.add(new StandardToWebSocketExtensionAdapter(extension));
        }
        return result;
    }

    @Override
    public void upgrade(ServerHttpRequest request, ServerHttpResponse response, @Nullable String selectedProtocol, List<WebSocketExtension> selectedExtensions, @Nullable Principal user, WebSocketHandler wsHandler, Map<String, Object> attrs) throws HandshakeFailureException {
        HttpHeaders headers = request.getHeaders();
        InetSocketAddress localAddr = null;
        try {
            localAddr = request.getLocalAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        InetSocketAddress remoteAddr = null;
        try {
            remoteAddr = request.getRemoteAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        StandardWebSocketSession session = new StandardWebSocketSession(headers, attrs, localAddr, remoteAddr, user);
        StandardWebSocketHandlerAdapter endpoint = new StandardWebSocketHandlerAdapter(wsHandler, session);
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        for (WebSocketExtension extension : selectedExtensions) {
            extensions.add(new WebSocketToStandardExtensionAdapter(extension));
        }
        HttpServletRequest servletRequest = this.getHttpServletRequest(request);
        HttpServletResponse servletResponse = this.getHttpServletResponse(response);
        StringBuffer requestUrl = servletRequest.getRequestURL();
        String path = servletRequest.getRequestURI();
        Map pathParams = Collections.emptyMap();
        ServerEndpointRegistration endpointConfig = new ServerEndpointRegistration(path, endpoint);
        endpointConfig.setSubprotocols(Collections.singletonList(selectedProtocol));
        endpointConfig.setExtensions(extensions);
        try {
            this.getContainer(servletRequest).upgradeHttpToWebSocket((Object)servletRequest, (Object)servletResponse, (ServerEndpointConfig)endpointConfig, pathParams);
        }
        catch (Exception ex) {
            throw new HandshakeFailureException("Servlet request failed to upgrade to WebSocket: " + String.valueOf(requestUrl), ex);
        }
    }

    protected ServerContainer getContainer(HttpServletRequest request) {
        ServletContext servletContext = request.getServletContext();
        String attrName = "jakarta.websocket.server.ServerContainer";
        ServerContainer container = (ServerContainer)servletContext.getAttribute(attrName);
        Assert.notNull((Object)container, (String)"No 'jakarta.websocket.server.ServerContainer' ServletContext attribute. Are you running in a Servlet container that supports JSR-356?");
        return container;
    }

    protected final HttpServletRequest getHttpServletRequest(ServerHttpRequest request) {
        Assert.isInstanceOf(ServletServerHttpRequest.class, (Object)request, (String)"ServletServerHttpRequest required");
        return ((ServletServerHttpRequest)request).getServletRequest();
    }

    protected final HttpServletResponse getHttpServletResponse(ServerHttpResponse response) {
        Assert.isInstanceOf(ServletServerHttpResponse.class, (Object)response, (String)"ServletServerHttpResponse required");
        return ((ServletServerHttpResponse)response).getServletResponse();
    }
}

