/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.jsp.JspException;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.tags.form.AbstractHtmlElementTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public class ErrorsTag
extends AbstractHtmlElementTag {
    public static final String SPAN_TAG = "span";
    private String delimiter = "<br/>";

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    protected boolean shouldRender() throws JspException {
        return this.getBindStatus().isError();
    }

    protected String getName() throws JspException {
        return this.getPath() + ".errors";
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        if (this.shouldRender()) {
            tagWriter.startTag(SPAN_TAG);
            this.writeDefaultAttributes(tagWriter);
            String delimiter = ObjectUtils.getDisplayString((Object)this.evaluate("delimiter", this.delimiter));
            String[] errorMessages = this.getBindStatus().getErrorMessages();
            for (int i = 0; i < errorMessages.length; ++i) {
                String errorMessage = errorMessages[i];
                if (i > 0) {
                    tagWriter.appendValue(delimiter);
                }
                tagWriter.appendValue(errorMessage);
            }
            tagWriter.endTag();
        }
        return 6;
    }
}

