/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.jsp.JspException;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.tags.form.AbstractHtmlInputElementTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public class SelectTag
extends AbstractHtmlInputElementTag {
    public static final String LIST_VALUE_PAGE_ATTRIBUTE = "org.springframework.web.servlet.tags.form.SelectTag.listValue";
    private String items;
    private String itemValue;
    private String itemLabel;
    private String size;
    private TagWriter tagWriter;
    static /* synthetic */ Class class$java$util$Collection;

    public void setItems(String items) {
        Assert.hasText((String)items, (String)"'items' cannot be null or zero length.");
        this.items = items;
    }

    public void setItemValue(String itemValue) {
        Assert.hasText((String)itemValue, (String)"'itemValue' cannot be null or zero length.");
        this.itemValue = itemValue;
    }

    public void setItemLabel(String itemLabel) {
        Assert.hasText((String)itemLabel, (String)"'itemLabel' cannot be null or zero length.");
        this.itemLabel = itemLabel;
    }

    public void setSize(String size) {
        Assert.hasText((String)size, (String)"'size' cannot be null or zero length.");
        this.size = size;
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        tagWriter.startTag("select");
        this.writeDefaultAttributes(tagWriter);
        tagWriter.writeOptionalAttributeValue("size", ObjectUtils.nullSafeToString((Object)this.evaluate("size", this.size)));
        if (this.items != null) {
            Object itemsObject = this.evaluate("items", this.items);
            if (itemsObject.getClass().isArray()) {
                this.renderFromCollection(CollectionUtils.toList((Object)itemsObject), tagWriter);
            } else if (itemsObject instanceof Collection) {
                this.renderFromCollection((Collection)itemsObject, tagWriter);
            } else if (itemsObject instanceof Map) {
                this.renderFromMap((Map)itemsObject, tagWriter);
            } else {
                throw new JspException("Property 'items' must be of type '" + (class$java$util$Collection == null ? (class$java$util$Collection = SelectTag.class$("java.util.Collection")) : class$java$util$Collection).getName() + "'.");
            }
            tagWriter.endTag();
            return 6;
        }
        tagWriter.forceBlock();
        this.tagWriter = tagWriter;
        this.pageContext.setAttribute(LIST_VALUE_PAGE_ATTRIBUTE, this.getValue());
        return 1;
    }

    private void renderFromMap(Map map, TagWriter tagWriter) throws JspException {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.renderOption(tagWriter, entry, entry.getKey().toString(), entry.getValue().toString());
        }
    }

    private void renderFromCollection(Collection itemList, TagWriter tagWriter) throws JspException {
        String valueProperty = this.itemValue == null ? null : ObjectUtils.nullSafeToString((Object)this.evaluate("itemValue", this.itemValue));
        String labelProperty = this.itemLabel == null ? null : ObjectUtils.nullSafeToString((Object)this.evaluate("itemLabel", this.itemLabel));
        Iterator iterator = itemList.iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            BeanWrapperImpl wrapper = new BeanWrapperImpl(item);
            String value = valueProperty == null ? item.toString() : wrapper.getPropertyValue(valueProperty).toString();
            String label = labelProperty == null ? item.toString() : ObjectUtils.nullSafeToString((Object)wrapper.getPropertyValue(labelProperty));
            this.renderOption(tagWriter, item, value, label);
        }
    }

    private void renderOption(TagWriter tagWriter, Object item, Object value, String label) throws JspException {
        tagWriter.startTag("option");
        tagWriter.writeAttribute("value", ObjectUtils.nullSafeToString((Object)value));
        if (this.isActiveValue(value) || this.isActiveValue(item)) {
            tagWriter.writeAttribute("selected", "true");
        }
        tagWriter.appendValue(label);
        tagWriter.endTag();
    }

    public int doEndTag() throws JspException {
        if (this.tagWriter != null) {
            this.tagWriter.endTag();
        }
        return 6;
    }

    public void doFinally() {
        super.doFinally();
        this.tagWriter = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

