/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.springframework.core.codec.CodecException;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClientException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class WebClientUtils {
    private static final String VALUE_NONE = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n";
    public static final Predicate<? super Throwable> WRAP_EXCEPTION_PREDICATE = t -> !(t instanceof WebClientException) && !(t instanceof CodecException);

    WebClientUtils() {
    }

    public static <T> Mono<ResponseEntity<T>> mapToEntity(ClientResponse response, Mono<T> bodyMono) {
        return bodyMono.defaultIfEmpty((Object)VALUE_NONE).map(body2 -> new ResponseEntity(body2 != VALUE_NONE ? body2 : null, response.headers().asHttpHeaders(), response.statusCode()));
    }

    public static <T> Mono<ResponseEntity<List<T>>> mapToEntityList(ClientResponse response, Publisher<T> body2) {
        return Flux.from(body2).collectList().map(list -> new ResponseEntity(list, response.headers().asHttpHeaders(), response.statusCode()));
    }

    public static String getRequestDescription(HttpMethod httpMethod, URI uri) {
        if (StringUtils.hasText((String)uri.getQuery())) {
            try {
                uri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), null, null);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return httpMethod.name() + " " + String.valueOf(uri);
    }
}

