/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.client;

import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.websockets.client.WebSocketClient;
import io.undertow.websockets.client.WebSocketClientNegotiation;
import io.undertow.websockets.core.WebSocketChannel;
import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Subscriber;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.ContextWebSocketHandler;
import org.springframework.web.reactive.socket.adapter.UndertowWebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.adapter.UndertowWebSocketSession;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import org.xnio.ChannelListener;
import org.xnio.IoFuture;
import org.xnio.XnioWorker;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class UndertowWebSocketClient
implements WebSocketClient {
    private static final Log logger = LogFactory.getLog(UndertowWebSocketClient.class);
    private static final int DEFAULT_POOL_BUFFER_SIZE = 8192;
    private final XnioWorker worker;
    private ByteBufferPool byteBufferPool;
    private final Consumer<WebSocketClient.ConnectionBuilder> builderConsumer;

    public UndertowWebSocketClient(XnioWorker worker) {
        this(worker, builder -> {});
    }

    public UndertowWebSocketClient(XnioWorker worker, Consumer<WebSocketClient.ConnectionBuilder> builderConsumer) {
        this(worker, (ByteBufferPool)new DefaultByteBufferPool(false, 8192), builderConsumer);
    }

    public UndertowWebSocketClient(XnioWorker worker, ByteBufferPool byteBufferPool, Consumer<WebSocketClient.ConnectionBuilder> builderConsumer) {
        Assert.notNull((Object)worker, (String)"XnioWorker must not be null");
        Assert.notNull((Object)byteBufferPool, (String)"ByteBufferPool must not be null");
        this.worker = worker;
        this.byteBufferPool = byteBufferPool;
        this.builderConsumer = builderConsumer;
    }

    public XnioWorker getXnioWorker() {
        return this.worker;
    }

    public void setByteBufferPool(ByteBufferPool byteBufferPool) {
        Assert.notNull((Object)byteBufferPool, (String)"ByteBufferPool must not be null");
        this.byteBufferPool = byteBufferPool;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.byteBufferPool;
    }

    public Consumer<WebSocketClient.ConnectionBuilder> getConnectionBuilderConsumer() {
        return this.builderConsumer;
    }

    @Override
    public Mono<Void> execute(URI url, WebSocketHandler handler) {
        return this.execute(url, new HttpHeaders(), handler);
    }

    @Override
    public Mono<Void> execute(URI url, HttpHeaders headers, WebSocketHandler handler) {
        return this.executeInternal(url, headers, handler);
    }

    private Mono<Void> executeInternal(final URI url, HttpHeaders headers, final WebSocketHandler handler) {
        final Sinks.Empty completion = Sinks.empty();
        return Mono.deferContextual(contextView -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Connecting to " + String.valueOf(url)));
            }
            List<String> protocols = handler.getSubProtocols();
            WebSocketClient.ConnectionBuilder builder = this.createConnectionBuilder(url);
            final DefaultNegotiation negotiation = new DefaultNegotiation(protocols, headers, builder);
            builder.setClientNegotiation((WebSocketClientNegotiation)negotiation);
            builder.connect().addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<WebSocketChannel, Object>(this){
                final /* synthetic */ UndertowWebSocketClient this$0;
                {
                    this.this$0 = this$0;
                }

                public void handleDone(WebSocketChannel channel, Object attachment) {
                    this.this$0.handleChannel(url, ContextWebSocketHandler.decorate(handler, contextView), (Sinks.Empty<Void>)completion, negotiation, channel);
                }

                public void handleFailed(IOException ex, Object attachment) {
                    completion.tryEmitError((Throwable)new IllegalStateException("Failed to connect to " + String.valueOf(url), ex));
                }
            }, null);
            return completion.asMono();
        });
    }

    protected WebSocketClient.ConnectionBuilder createConnectionBuilder(URI url) {
        WebSocketClient.ConnectionBuilder builder = io.undertow.websockets.client.WebSocketClient.connectionBuilder((XnioWorker)this.getXnioWorker(), (ByteBufferPool)this.getByteBufferPool(), (URI)url);
        this.builderConsumer.accept(builder);
        return builder;
    }

    private void handleChannel(URI url, WebSocketHandler handler, Sinks.Empty<Void> completionSink, DefaultNegotiation negotiation, WebSocketChannel channel) {
        HandshakeInfo info = this.createHandshakeInfo(url, negotiation);
        DefaultDataBufferFactory bufferFactory = DefaultDataBufferFactory.sharedInstance;
        UndertowWebSocketSession session = new UndertowWebSocketSession(channel, info, (DataBufferFactory)bufferFactory, completionSink);
        UndertowWebSocketHandlerAdapter adapter = new UndertowWebSocketHandlerAdapter(session);
        channel.getReceiveSetter().set((ChannelListener)adapter);
        channel.resumeReceives();
        handler.handle(session).checkpoint(String.valueOf(url) + " [UndertowWebSocketClient]").subscribe((Subscriber)session);
    }

    private HandshakeInfo createHandshakeInfo(URI url, DefaultNegotiation negotiation) {
        HttpHeaders responseHeaders = negotiation.getResponseHeaders();
        String protocol = responseHeaders.getFirst("Sec-WebSocket-Protocol");
        return new HandshakeInfo(url, responseHeaders, (Mono<Principal>)Mono.empty(), protocol);
    }

    private static final class DefaultNegotiation
    extends WebSocketClientNegotiation {
        private final HttpHeaders requestHeaders;
        private final HttpHeaders responseHeaders = new HttpHeaders();
        private final @Nullable WebSocketClientNegotiation delegate;

        public DefaultNegotiation(List<String> protocols, HttpHeaders requestHeaders, WebSocketClient.ConnectionBuilder connectionBuilder) {
            super(protocols, Collections.emptyList());
            this.requestHeaders = requestHeaders;
            this.delegate = connectionBuilder.getClientNegotiation();
        }

        public HttpHeaders getResponseHeaders() {
            return this.responseHeaders;
        }

        public void beforeRequest(Map<String, List<String>> headers) {
            this.requestHeaders.forEach(headers::put);
            if (this.delegate != null) {
                this.delegate.beforeRequest(headers);
            }
        }

        public void afterRequest(Map<String, List<String>> headers) {
            this.responseHeaders.putAll(headers);
            if (this.delegate != null) {
                this.delegate.afterRequest(headers);
            }
        }
    }
}

