/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import jakarta.websocket.CloseReason;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.SendHandler;
import jakarta.websocket.SendResult;
import jakarta.websocket.Session;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.adapter.AbstractListenerWebSocketSession;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class StandardWebSocketSession
extends AbstractListenerWebSocketSession<Session> {
    public StandardWebSocketSession(Session session, HandshakeInfo info, DataBufferFactory factory) {
        this(session, info, factory, null);
    }

    public StandardWebSocketSession(Session session, HandshakeInfo info, DataBufferFactory factory, @Nullable Sinks.Empty<Void> completionSink) {
        super(session, session.getId(), info, factory, completionSink);
    }

    @Override
    protected boolean canSuspendReceiving() {
        return false;
    }

    @Override
    protected void suspendReceiving() {
    }

    @Override
    protected void resumeReceiving() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean sendMessage(WebSocketMessage message) throws IOException {
        DataBuffer dataBuffer = message.getPayload();
        RemoteEndpoint.Async remote = ((Session)this.getDelegate()).getAsyncRemote();
        if (WebSocketMessage.Type.TEXT.equals((Object)message.getType())) {
            this.getSendProcessor().setReadyToSend(false);
            String text = dataBuffer.toString(StandardCharsets.UTF_8);
            remote.sendText(text, (SendHandler)new SendProcessorCallback());
            return true;
        }
        if (WebSocketMessage.Type.BINARY.equals((Object)message.getType())) {
            this.getSendProcessor().setReadyToSend(false);
        }
        try (DataBuffer.ByteBufferIterator iterator = dataBuffer.readableByteBuffers();){
            block10: while (iterator.hasNext()) {
                ByteBuffer byteBuffer = (ByteBuffer)iterator.next();
                switch (message.getType()) {
                    case BINARY: {
                        remote.sendBinary(byteBuffer, (SendHandler)new SendProcessorCallback());
                        continue block10;
                    }
                    case PING: {
                        remote.sendPing(byteBuffer);
                        continue block10;
                    }
                    case PONG: {
                        remote.sendPong(byteBuffer);
                        continue block10;
                    }
                }
            }
            return true;
            throw new IllegalArgumentException("Unexpected message type: " + String.valueOf((Object)message.getType()));
        }
    }

    @Override
    public boolean isOpen() {
        return ((Session)this.getDelegate()).isOpen();
    }

    @Override
    public Mono<Void> close(CloseStatus status) {
        try {
            CloseReason.CloseCode code = CloseReason.CloseCodes.getCloseCode((int)status.getCode());
            ((Session)this.getDelegate()).close(new CloseReason(code, status.getReason()));
        }
        catch (IOException ex) {
            return Mono.error((Throwable)ex);
        }
        return Mono.empty();
    }

    private final class SendProcessorCallback
    implements SendHandler {
        private SendProcessorCallback() {
        }

        public void onResult(SendResult result) {
            if (result.isOK()) {
                StandardWebSocketSession.this.getSendProcessor().setReadyToSend(true);
                StandardWebSocketSession.this.getSendProcessor().onWritePossible();
            } else {
                StandardWebSocketSession.this.getSendProcessor().cancel();
                StandardWebSocketSession.this.getSendProcessor().onError(result.getException());
            }
        }
    }
}

