/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.adapter.AbstractListenerWebSocketSession;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class JettyWebSocketSession
extends AbstractListenerWebSocketSession<Session> {
    public JettyWebSocketSession(Session session, HandshakeInfo info, DataBufferFactory factory) {
        this(session, info, factory, null);
    }

    public JettyWebSocketSession(Session session, HandshakeInfo info, DataBufferFactory factory, @Nullable Sinks.Empty<Void> completionSink) {
        super(session, ObjectUtils.getIdentityHexString((Object)session), info, factory, completionSink);
    }

    @Override
    protected boolean canSuspendReceiving() {
        return false;
    }

    @Override
    protected void suspendReceiving() {
    }

    @Override
    protected void resumeReceiving() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean sendMessage(WebSocketMessage message) throws IOException {
        DataBuffer dataBuffer = message.getPayload();
        Session session = (Session)this.getDelegate();
        if (WebSocketMessage.Type.TEXT.equals((Object)message.getType())) {
            this.getSendProcessor().setReadyToSend(false);
            String text = dataBuffer.toString(StandardCharsets.UTF_8);
            session.sendText(text, (Callback)new SendProcessorCallback());
            return true;
        }
        if (WebSocketMessage.Type.BINARY.equals((Object)message.getType())) {
            this.getSendProcessor().setReadyToSend(false);
        }
        try (DataBuffer.ByteBufferIterator iterator = dataBuffer.readableByteBuffers();){
            block10: while (iterator.hasNext()) {
                ByteBuffer byteBuffer = (ByteBuffer)iterator.next();
                switch (message.getType()) {
                    case BINARY: {
                        session.sendBinary(byteBuffer, (Callback)new SendProcessorCallback());
                        continue block10;
                    }
                    case PING: {
                        session.sendPing(byteBuffer, (Callback)new SendProcessorCallback());
                        continue block10;
                    }
                    case PONG: {
                        session.sendPong(byteBuffer, (Callback)new SendProcessorCallback());
                        continue block10;
                    }
                }
            }
            return true;
            throw new IllegalArgumentException("Unexpected message type: " + String.valueOf((Object)message.getType()));
        }
    }

    @Override
    public boolean isOpen() {
        return ((Session)this.getDelegate()).isOpen();
    }

    @Override
    public Mono<Void> close(CloseStatus status) {
        Callback.Completable callback = new Callback.Completable();
        ((Session)this.getDelegate()).close(status.getCode(), status.getReason(), (Callback)callback);
        return Mono.fromFuture((CompletableFuture)callback);
    }

    private final class SendProcessorCallback
    implements Callback {
        private SendProcessorCallback() {
        }

        public void fail(Throwable x) {
            JettyWebSocketSession.this.getSendProcessor().cancel();
            JettyWebSocketSession.this.getSendProcessor().onError(x);
        }

        public void succeed() {
            JettyWebSocketSession.this.getSendProcessor().setReadyToSend(true);
            JettyWebSocketSession.this.getSendProcessor().onWritePossible();
        }
    }
}

