/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.condition;

import java.util.Locale;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.result.condition.NameValueExpression;
import org.springframework.web.server.ServerWebExchange;

abstract class AbstractNameValueExpression<T>
implements NameValueExpression<T> {
    protected final String name;
    @Nullable
    protected final T value;
    protected final boolean isNegated;

    AbstractNameValueExpression(String expression) {
        int separator = expression.indexOf(61);
        if (separator == -1) {
            this.isNegated = expression.startsWith("!");
            this.name = this.isNegated ? expression.substring(1) : expression;
            this.value = null;
        } else {
            this.isNegated = separator > 0 && expression.charAt(separator - 1) == '!';
            this.name = this.isNegated ? expression.substring(0, separator - 1) : expression.substring(0, separator);
            this.value = this.parseValue(expression.substring(separator + 1));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public T getValue() {
        return this.value;
    }

    @Override
    public boolean isNegated() {
        return this.isNegated;
    }

    public final boolean match(ServerWebExchange exchange2) {
        boolean isMatch = this.value != null ? this.matchValue(exchange2) : this.matchName(exchange2);
        return this.isNegated != isMatch;
    }

    protected abstract boolean isCaseSensitiveName();

    protected abstract T parseValue(String var1);

    protected abstract boolean matchName(ServerWebExchange var1);

    protected abstract boolean matchValue(ServerWebExchange var1);

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbstractNameValueExpression that = (AbstractNameValueExpression)other;
        return (this.isCaseSensitiveName() ? this.name.equals(that.name) : this.name.equalsIgnoreCase(that.name)) && ObjectUtils.nullSafeEquals(this.value, that.value) && this.isNegated == that.isNegated;
    }

    public int hashCode() {
        int result = (this.isCaseSensitiveName() ? this.name : this.name.toLowerCase(Locale.ROOT)).hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.value);
        result = 31 * result + (this.isNegated ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.value != null) {
            builder.append(this.name);
            if (this.isNegated) {
                builder.append('!');
            }
            builder.append('=');
            builder.append(this.value);
        } else {
            if (this.isNegated) {
                builder.append('!');
            }
            builder.append(this.name);
        }
        return builder.toString();
    }
}

