/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.handler;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.Ordered;
import org.springframework.core.log.LogDelegateFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.cors.reactive.CorsProcessor;
import org.springframework.web.cors.reactive.CorsUtils;
import org.springframework.web.cors.reactive.DefaultCorsProcessor;
import org.springframework.web.cors.reactive.UrlBasedCorsConfigurationSource;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Mono;

public abstract class AbstractHandlerMapping
extends ApplicationObjectSupport
implements HandlerMapping,
Ordered,
BeanNameAware {
    private static final WebHandler NO_OP_HANDLER = exchange -> Mono.empty();
    protected final Log mappingsLogger = LogDelegateFactory.getHiddenLog((String)(HandlerMapping.class.getName() + ".Mappings"));
    private final PathPatternParser patternParser = new PathPatternParser();
    @Nullable
    private CorsConfigurationSource corsConfigurationSource;
    private CorsProcessor corsProcessor = new DefaultCorsProcessor();
    private int order = Integer.MAX_VALUE;
    @Nullable
    private String beanName;

    public void setUseCaseSensitiveMatch(boolean caseSensitiveMatch) {
        this.patternParser.setCaseSensitive(caseSensitiveMatch);
    }

    @Deprecated(since="6.0")
    public void setUseTrailingSlashMatch(boolean trailingSlashMatch) {
        this.patternParser.setMatchOptionalTrailingSeparator(trailingSlashMatch);
    }

    public PathPatternParser getPathPatternParser() {
        return this.patternParser;
    }

    public void setCorsConfigurations(Map<String, CorsConfiguration> corsConfigurations) {
        Assert.notNull(corsConfigurations, (String)"corsConfigurations must not be null");
        if (!corsConfigurations.isEmpty()) {
            UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource(this.patternParser);
            source.setCorsConfigurations(corsConfigurations);
            this.corsConfigurationSource = source;
        } else {
            this.corsConfigurationSource = null;
        }
    }

    public void setCorsConfigurationSource(CorsConfigurationSource corsConfigurationSource) {
        Assert.notNull((Object)corsConfigurationSource, (String)"corsConfigurationSource must not be null");
        this.corsConfigurationSource = corsConfigurationSource;
    }

    public void setCorsProcessor(CorsProcessor corsProcessor) {
        Assert.notNull((Object)corsProcessor, (String)"CorsProcessor must not be null");
        this.corsProcessor = corsProcessor;
    }

    public CorsProcessor getCorsProcessor() {
        return this.corsProcessor;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    protected String formatMappingName() {
        return this.beanName != null ? "'" + this.beanName + "'" : "<unknown>";
    }

    @Override
    public Mono<Object> getHandler(ServerWebExchange exchange) {
        return this.getHandlerInternal(exchange).map(handler -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(exchange.getLogPrefix() + "Mapped to " + handler));
            }
            ServerHttpRequest request = exchange.getRequest();
            if (this.hasCorsConfigurationSource(handler) || CorsUtils.isPreFlightRequest((ServerHttpRequest)request)) {
                CorsConfiguration config = this.corsConfigurationSource != null ? this.corsConfigurationSource.getCorsConfiguration(exchange) : null;
                CorsConfiguration handlerConfig = this.getCorsConfiguration(handler, exchange);
                CorsConfiguration corsConfiguration = config = config != null ? config.combine(handlerConfig) : handlerConfig;
                if (config != null) {
                    config.validateAllowCredentials();
                }
                if (!this.corsProcessor.process(config, exchange) || CorsUtils.isPreFlightRequest((ServerHttpRequest)request)) {
                    return NO_OP_HANDLER;
                }
            }
            return handler;
        });
    }

    protected abstract Mono<?> getHandlerInternal(ServerWebExchange var1);

    protected boolean hasCorsConfigurationSource(Object handler) {
        return handler instanceof CorsConfigurationSource || this.corsConfigurationSource != null;
    }

    @Nullable
    protected CorsConfiguration getCorsConfiguration(Object handler, ServerWebExchange exchange) {
        if (handler instanceof CorsConfigurationSource) {
            return ((CorsConfigurationSource)handler).getCorsConfiguration(exchange);
        }
        return null;
    }
}

