/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.result.condition.NameValueExpression;
import org.springframework.web.reactive.result.method.AbstractHandlerMethodMapping;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import org.springframework.web.server.MethodNotAllowedException;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;
import org.springframework.web.util.pattern.PathPattern;

public abstract class RequestMappingInfoHandlerMapping
extends AbstractHandlerMethodMapping<RequestMappingInfo> {
    private static final Method HTTP_OPTIONS_HANDLE_METHOD;

    @Override
    protected RequestMappingInfo getMatchingMapping(RequestMappingInfo info, ServerWebExchange exchange) {
        return info.getMatchingCondition(exchange);
    }

    @Override
    protected Comparator<RequestMappingInfo> getMappingComparator(ServerWebExchange exchange) {
        return (info1, info2) -> info1.compareTo((RequestMappingInfo)info2, exchange);
    }

    @Override
    protected void handleMatch(RequestMappingInfo info, HandlerMethod handlerMethod, ServerWebExchange exchange) {
        Map matrixVariables;
        Map uriVariables;
        PathPattern bestPattern;
        super.handleMatch(info, handlerMethod, exchange);
        PathContainer lookupPath = exchange.getRequest().getPath().pathWithinApplication();
        Set<PathPattern> patterns = info.getPatternsCondition().getPatterns();
        if (patterns.isEmpty()) {
            bestPattern = this.getPathPatternParser().parse(lookupPath.value());
            uriVariables = Collections.emptyMap();
            matrixVariables = Collections.emptyMap();
        } else {
            bestPattern = patterns.iterator().next();
            PathPattern.PathMatchInfo result = bestPattern.matchAndExtract(lookupPath);
            Assert.notNull((Object)result, () -> "Expected bestPattern: " + bestPattern + " to match lookupPath " + lookupPath);
            uriVariables = result.getUriVariables();
            matrixVariables = result.getMatrixVariables();
        }
        exchange.getAttributes().put(BEST_MATCHING_HANDLER_ATTRIBUTE, handlerMethod);
        exchange.getAttributes().put(BEST_MATCHING_PATTERN_ATTRIBUTE, bestPattern);
        exchange.getAttributes().put(URI_TEMPLATE_VARIABLES_ATTRIBUTE, uriVariables);
        exchange.getAttributes().put(MATRIX_VARIABLES_ATTRIBUTE, matrixVariables);
        if (!info.getProducesCondition().getProducibleMediaTypes().isEmpty()) {
            Set<MediaType> mediaTypes = info.getProducesCondition().getProducibleMediaTypes();
            exchange.getAttributes().put(PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE, mediaTypes);
        }
    }

    @Override
    protected HandlerMethod handleNoMatch(Set<RequestMappingInfo> infos, ServerWebExchange exchange) throws Exception {
        PartialMatchHelper helper = new PartialMatchHelper(infos, exchange);
        if (helper.isEmpty()) {
            return null;
        }
        ServerHttpRequest request = exchange.getRequest();
        if (helper.hasMethodsMismatch()) {
            String httpMethod = request.getMethodValue();
            Set<HttpMethod> methods = helper.getAllowedMethods();
            if (HttpMethod.OPTIONS.matches(httpMethod)) {
                HttpOptionsHandler handler = new HttpOptionsHandler(methods);
                return new HandlerMethod((Object)handler, HTTP_OPTIONS_HANDLE_METHOD);
            }
            throw new MethodNotAllowedException(httpMethod, methods);
        }
        if (helper.hasConsumesMismatch()) {
            MediaType contentType2;
            Set<MediaType> mediaTypes = helper.getConsumableMediaTypes();
            try {
                contentType2 = request.getHeaders().getContentType();
            }
            catch (InvalidMediaTypeException ex) {
                throw new UnsupportedMediaTypeStatusException(ex.getMessage());
            }
            throw new UnsupportedMediaTypeStatusException(contentType2, new ArrayList<MediaType>(mediaTypes));
        }
        if (helper.hasProducesMismatch()) {
            Set<MediaType> mediaTypes = helper.getProducibleMediaTypes();
            throw new NotAcceptableStatusException(new ArrayList<MediaType>(mediaTypes));
        }
        if (helper.hasParamsMismatch()) {
            throw new ServerWebInputException("Unsatisfied query parameter conditions: " + helper.getParamConditions() + ", actual parameters: " + request.getQueryParams());
        }
        return null;
    }

    static {
        try {
            HTTP_OPTIONS_HANDLE_METHOD = HttpOptionsHandler.class.getMethod("handle", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("No handler for HTTP OPTIONS", ex);
        }
    }

    private static class HttpOptionsHandler {
        private final HttpHeaders headers = new HttpHeaders();

        public HttpOptionsHandler(Set<HttpMethod> declaredMethods) {
            this.headers.setAllow(HttpOptionsHandler.initAllowedHttpMethods(declaredMethods));
        }

        private static Set<HttpMethod> initAllowedHttpMethods(Set<HttpMethod> declaredMethods) {
            if (declaredMethods.isEmpty()) {
                return EnumSet.allOf(HttpMethod.class).stream().filter(method2 -> !method2.equals((Object)HttpMethod.TRACE)).collect(Collectors.toSet());
            }
            LinkedHashSet<HttpMethod> result = new LinkedHashSet<HttpMethod>(declaredMethods);
            if (result.contains(HttpMethod.GET)) {
                result.add(HttpMethod.HEAD);
            }
            return result;
        }

        public HttpHeaders handle() {
            return this.headers;
        }
    }

    private static class PartialMatchHelper {
        private final List<PartialMatch> partialMatches = new ArrayList<PartialMatch>();

        public PartialMatchHelper(Set<RequestMappingInfo> infos, ServerWebExchange exchange) {
            this.partialMatches.addAll(infos.stream().filter(info -> info.getPatternsCondition().getMatchingCondition(exchange) != null).map(info -> new PartialMatch((RequestMappingInfo)info, exchange)).collect(Collectors.toList()));
        }

        public boolean isEmpty() {
            return this.partialMatches.isEmpty();
        }

        public boolean hasMethodsMismatch() {
            return this.partialMatches.stream().noneMatch(PartialMatch::hasMethodsMatch);
        }

        public boolean hasConsumesMismatch() {
            return this.partialMatches.stream().noneMatch(PartialMatch::hasConsumesMatch);
        }

        public boolean hasProducesMismatch() {
            return this.partialMatches.stream().noneMatch(PartialMatch::hasProducesMatch);
        }

        public boolean hasParamsMismatch() {
            return this.partialMatches.stream().noneMatch(PartialMatch::hasParamsMatch);
        }

        public Set<HttpMethod> getAllowedMethods() {
            return this.partialMatches.stream().flatMap(m -> m.getInfo().getMethodsCondition().getMethods().stream()).map(requestMethod -> HttpMethod.resolve((String)requestMethod.name())).collect(Collectors.toSet());
        }

        public Set<MediaType> getConsumableMediaTypes() {
            return this.partialMatches.stream().filter(PartialMatch::hasMethodsMatch).flatMap(m -> m.getInfo().getConsumesCondition().getConsumableMediaTypes().stream()).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        public Set<MediaType> getProducibleMediaTypes() {
            return this.partialMatches.stream().filter(PartialMatch::hasConsumesMatch).flatMap(m -> m.getInfo().getProducesCondition().getProducibleMediaTypes().stream()).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        public List<Set<NameValueExpression<String>>> getParamConditions() {
            return this.partialMatches.stream().filter(PartialMatch::hasProducesMatch).map(match -> match.getInfo().getParamsCondition().getExpressions()).collect(Collectors.toList());
        }

        private static class PartialMatch {
            private final RequestMappingInfo info;
            private final boolean methodsMatch;
            private final boolean consumesMatch;
            private final boolean producesMatch;
            private final boolean paramsMatch;

            public PartialMatch(RequestMappingInfo info, ServerWebExchange exchange) {
                this.info = info;
                this.methodsMatch = info.getMethodsCondition().getMatchingCondition(exchange) != null;
                this.consumesMatch = info.getConsumesCondition().getMatchingCondition(exchange) != null;
                this.producesMatch = info.getProducesCondition().getMatchingCondition(exchange) != null;
                this.paramsMatch = info.getParamsCondition().getMatchingCondition(exchange) != null;
            }

            public RequestMappingInfo getInfo() {
                return this.info;
            }

            public boolean hasMethodsMatch() {
                return this.methodsMatch;
            }

            public boolean hasConsumesMatch() {
                return this.hasMethodsMatch() && this.consumesMatch;
            }

            public boolean hasProducesMatch() {
                return this.hasConsumesMatch() && this.producesMatch;
            }

            public boolean hasParamsMatch() {
                return this.hasProducesMatch() && this.paramsMatch;
            }

            public String toString() {
                return this.info.toString();
            }
        }
    }
}

