/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.support;

import java.util.Iterator;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.FlowExecutionContext;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.ScopeType;

public abstract class AutowiringSupport {
    private int autowireMode = 1;
    private boolean dependencyCheck = false;

    public int getAutowireMode() {
        return this.autowireMode;
    }

    public void setAutowireMode(int autowireMode) {
        this.autowireMode = autowireMode;
    }

    public boolean getDependencyCheck() {
        return this.dependencyCheck;
    }

    public void setDependencyCheck(boolean dependencyCheck) {
        this.dependencyCheck = dependencyCheck;
    }

    public void autowire(FlowExecutionContext flowExecutionContext) {
        if (flowExecutionContext.isActive()) {
            for (FlowSession flowSession = flowExecutionContext.getActiveSession(); flowSession != null; flowSession = flowSession.getParent()) {
                this.autowire(ScopeType.FLASH, flowSession.getFlashMap());
                this.autowire(ScopeType.FLOW, flowSession.getScope());
            }
            this.autowire(ScopeType.CONVERSATION, flowExecutionContext.getConversationScope());
        }
    }

    protected void autowire(ScopeType scopeType, MutableAttributeMap scope) {
        Iterator keys = scope.asMap().keySet().iterator();
        while (keys.hasNext()) {
            Object value;
            String key = (String)keys.next();
            if (!this.shouldBeAutowired(scopeType, key, value = scope.get(key))) continue;
            this.autowire(scopeType, key, value);
        }
    }

    protected boolean shouldBeAutowired(ScopeType scopeType, String key, Object value) {
        return true;
    }

    protected void autowire(ScopeType scopeType, String key, Object value) {
        this.getBeanFactory().autowireBeanProperties(value, this.autowireMode, this.dependencyCheck);
    }

    protected abstract AutowireCapableBeanFactory getBeanFactory();
}

