/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor;

import java.io.Serializable;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.FlowExecutionContext;
import org.springframework.webflow.execution.ViewSelection;
import org.springframework.webflow.execution.support.ApplicationView;
import org.springframework.webflow.execution.support.ExternalRedirect;
import org.springframework.webflow.execution.support.FlowDefinitionRedirect;
import org.springframework.webflow.execution.support.FlowExecutionRedirect;

public class ResponseInstruction
implements Serializable {
    private String flowExecutionKey;
    private transient FlowExecutionContext flowExecutionContext;
    private ViewSelection viewSelection;

    public ResponseInstruction(String flowExecutionKey, FlowExecutionContext flowExecutionContext, ViewSelection viewSelection) {
        Assert.notNull((Object)flowExecutionKey, (String)"The flow execution key is required");
        this.flowExecutionKey = flowExecutionKey;
        this.init(flowExecutionContext, viewSelection);
    }

    public ResponseInstruction(FlowExecutionContext flowExecutionContext, ViewSelection viewSelection) {
        this.init(flowExecutionContext, viewSelection);
    }

    private void init(FlowExecutionContext flowExecutionContext, ViewSelection viewSelection) {
        Assert.notNull((Object)flowExecutionContext, (String)"The flow execution context is required");
        Assert.notNull((Object)viewSelection, (String)"The view selection is required");
        this.flowExecutionContext = flowExecutionContext;
        this.viewSelection = viewSelection;
    }

    public String getFlowExecutionKey() {
        return this.flowExecutionKey;
    }

    public FlowExecutionContext getFlowExecutionContext() {
        return this.flowExecutionContext;
    }

    public ViewSelection getViewSelection() {
        return this.viewSelection;
    }

    public boolean isActiveView() {
        return this.isApplicationView() && this.flowExecutionContext.isActive();
    }

    public boolean isEndingView() {
        return this.isApplicationView() && !this.flowExecutionContext.isActive();
    }

    public boolean isApplicationView() {
        return this.viewSelection instanceof ApplicationView;
    }

    public boolean isFlowExecutionRedirect() {
        return this.viewSelection instanceof FlowExecutionRedirect;
    }

    public boolean isFlowDefinitionRedirect() {
        return this.viewSelection instanceof FlowDefinitionRedirect;
    }

    public boolean isExternalRedirect() {
        return this.viewSelection instanceof ExternalRedirect;
    }

    public boolean isNull() {
        return this.viewSelection == ViewSelection.NULL_VIEW;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ResponseInstruction)) {
            return false;
        }
        ResponseInstruction other = (ResponseInstruction)o;
        if (this.getFlowExecutionKey() != null) {
            return this.getFlowExecutionKey().equals(other.getFlowExecutionKey()) && this.viewSelection.equals(other.viewSelection);
        }
        return other.getFlowExecutionKey() == null && this.viewSelection.equals(other.viewSelection);
    }

    public int hashCode() {
        int hashCode = this.viewSelection.hashCode();
        if (this.getFlowExecutionKey() != null) {
            hashCode += this.getFlowExecutionKey().hashCode();
        }
        return hashCode;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("flowExecutionKey", (Object)this.flowExecutionKey).append("viewSelection", (Object)this.viewSelection).append("flowExecutionContext", (Object)this.flowExecutionContext).toString();
    }
}

