/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.continuation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.continuation.ContinuationCreationException;
import org.springframework.webflow.execution.repository.continuation.ContinuationUnmarshalException;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuation;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuationFactory;
import org.springframework.webflow.execution.repository.continuation.SerializedFlowExecutionContinuation;

public class SerializedFlowExecutionContinuationFactory
implements FlowExecutionContinuationFactory {
    private boolean compress = true;

    public boolean getCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public FlowExecutionContinuation createContinuation(FlowExecution flowExecution) throws ContinuationCreationException {
        return new SerializedFlowExecutionContinuation(flowExecution, this.compress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowExecutionContinuation createContinuation(byte[] bytes) throws ContinuationUnmarshalException {
        FlowExecutionContinuation flowExecutionContinuation;
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
        try {
            flowExecutionContinuation = (FlowExecutionContinuation)ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ContinuationUnmarshalException("IO problem while creating a flow execution continuation", e);
            }
            catch (ClassNotFoundException e) {
                throw new ContinuationUnmarshalException("Class not found while creating a flow execution continuation", e);
            }
        }
        ois.close();
        return flowExecutionContinuation;
    }
}

