/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.CollectionUtils;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.impl.FlowExecutionImpl;
import org.springframework.webflow.engine.impl.FlowExecutionListeners;
import org.springframework.webflow.engine.impl.FlowSessionImpl;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionContext;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.FlowSessionStatus;
import org.springframework.webflow.execution.ViewSelection;

class RequestControlContextImpl
implements RequestControlContext {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$webflow$engine$impl$RequestControlContextImpl == null ? (class$org$springframework$webflow$engine$impl$RequestControlContextImpl = RequestControlContextImpl.class$("org.springframework.webflow.engine.impl.RequestControlContextImpl")) : class$org$springframework$webflow$engine$impl$RequestControlContextImpl));
    private FlowExecutionImpl flowExecution;
    private ExternalContext externalContext;
    private LocalAttributeMap requestScope = new LocalAttributeMap();
    private AttributeMap attributes = CollectionUtils.EMPTY_ATTRIBUTE_MAP;
    private Event lastEvent;
    private Transition lastTransition;
    static /* synthetic */ Class class$org$springframework$webflow$engine$impl$RequestControlContextImpl;

    public RequestControlContextImpl(FlowExecutionImpl flowExecution, ExternalContext externalContext) {
        Assert.notNull((Object)flowExecution, (String)"The owning flow execution is required");
        this.flowExecution = flowExecution;
        this.externalContext = externalContext;
    }

    public FlowDefinition getActiveFlow() {
        return this.flowExecution.getActiveSession().getDefinition();
    }

    public StateDefinition getCurrentState() {
        return this.flowExecution.getActiveSession().getState();
    }

    public MutableAttributeMap getRequestScope() {
        return this.requestScope;
    }

    public MutableAttributeMap getFlashScope() {
        return this.flowExecution.getActiveSession().getFlashMap();
    }

    public MutableAttributeMap getFlowScope() {
        return this.flowExecution.getActiveSession().getScope();
    }

    public MutableAttributeMap getConversationScope() {
        return this.flowExecution.getConversationScope();
    }

    public ParameterMap getRequestParameters() {
        return this.externalContext.getRequestParameterMap();
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public FlowExecutionContext getFlowExecutionContext() {
        return this.flowExecution;
    }

    public Event getLastEvent() {
        return this.lastEvent;
    }

    public TransitionDefinition getLastTransition() {
        return this.lastTransition;
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    public void setAttributes(AttributeMap attributes) {
        this.attributes = attributes == null ? CollectionUtils.EMPTY_ATTRIBUTE_MAP : attributes;
    }

    public AttributeMap getModel() {
        return this.getConversationScope().union(this.getFlowScope()).union(this.getFlashScope()).union(this.getRequestScope());
    }

    public void setLastEvent(Event lastEvent) {
        this.lastEvent = lastEvent;
    }

    public void setLastTransition(Transition lastTransition) {
        this.lastTransition = lastTransition;
    }

    public void setCurrentState(State state) {
        this.getExecutionListeners().fireStateEntering(this, state);
        State previousState = this.getCurrentStateInternal();
        this.flowExecution.setCurrentState(state);
        if (previousState == null) {
            this.getActiveSession().setStatus(FlowSessionStatus.ACTIVE);
        }
        this.getExecutionListeners().fireStateEntered(this, previousState);
    }

    public ViewSelection start(Flow flow, MutableAttributeMap input) throws FlowExecutionException {
        if (input == null) {
            input = new LocalAttributeMap();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Activating new session for flow '" + flow.getId() + "' in state '" + flow.getStartState().getId() + "' with input " + input));
        }
        this.getExecutionListeners().fireSessionStarting(this, flow, input);
        FlowSession session = this.flowExecution.activateSession(flow);
        this.getExecutionListeners().fireSessionCreated(this, session);
        ViewSelection selectedView = flow.start(this, input);
        this.getExecutionListeners().fireSessionStarted(this, session);
        return selectedView;
    }

    public ViewSelection signalEvent(Event event) throws FlowExecutionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Signaling event '" + event.getId() + "' in state '" + this.getCurrentState().getId() + "' of flow '" + this.getActiveFlow().getId() + "'"));
        }
        this.setLastEvent(event);
        this.getExecutionListeners().fireEventSignaled(this, event);
        ViewSelection selectedView = this.getActiveFlowInternal().onEvent(this);
        return selectedView;
    }

    public FlowSession endActiveFlowSession(MutableAttributeMap output) throws IllegalStateException {
        FlowSession session = this.getFlowExecutionContext().getActiveSession();
        this.getExecutionListeners().fireSessionEnding(this, session, output);
        this.getActiveFlowInternal().end(this, output);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Ending active session " + session + "; exposed session output is " + output));
        }
        session = this.flowExecution.endActiveFlowSession();
        this.getExecutionListeners().fireSessionEnded(this, session, output);
        return session;
    }

    public ViewSelection execute(Transition transition) {
        return transition.execute(this.getCurrentStateInternal(), this);
    }

    protected FlowExecutionListeners getExecutionListeners() {
        return this.flowExecution.getListeners();
    }

    protected Flow getActiveFlowInternal() {
        return (Flow)this.getActiveSession().getDefinition();
    }

    protected State getCurrentStateInternal() {
        return (State)this.getActiveSession().getState();
    }

    protected FlowSessionImpl getActiveSession() {
        return this.flowExecution.getActiveSessionInternal();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("externalContext", (Object)this.externalContext).append("requestScope", (Object)this.requestScope).append("attributes", (Object)this.attributes).append("flowExecution", (Object)this.flowExecution).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

