/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder.xml;

import java.io.IOException;
import org.springframework.core.io.ClassPathResource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebFlowEntityResolver
implements EntityResolver {
    private static final String WEBFLOW_ELEMENT = "spring-webflow-1.0";

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId != null && systemId.indexOf(WEBFLOW_ELEMENT) > systemId.lastIndexOf("/")) {
            String filename = systemId.substring(systemId.indexOf(WEBFLOW_ELEMENT));
            try {
                ClassPathResource resource = new ClassPathResource(filename, this.getClass());
                InputSource source = new InputSource(resource.getInputStream());
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                return source;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return null;
    }
}

