/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine;

import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.FlowAttributeMapper;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ViewSelection;

public class SubflowState
extends TransitionableState {
    private Flow subflow;
    private FlowAttributeMapper attributeMapper;

    public SubflowState(Flow flow, String id, Flow subflow) throws IllegalArgumentException {
        super(flow, id);
        this.setSubflow(subflow);
    }

    public Flow getSubflow() {
        return this.subflow;
    }

    private void setSubflow(Flow subflow) {
        Assert.notNull((Object)subflow, (String)"A subflow state must have a subflow; the subflow is required");
        this.subflow = subflow;
    }

    public FlowAttributeMapper getAttributeMapper() {
        return this.attributeMapper;
    }

    public void setAttributeMapper(FlowAttributeMapper attributeMapper) {
        this.attributeMapper = attributeMapper;
    }

    protected ViewSelection doEnter(RequestControlContext context) throws FlowExecutionException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Spawning subflow '" + this.getSubflow().getId() + "' within flow '" + this.getFlow().getId() + "'"));
        }
        return context.start(this.getSubflow(), this.createSubflowInput(context));
    }

    protected MutableAttributeMap createSubflowInput(RequestContext context) {
        if (this.getAttributeMapper() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Messaging the configured attribute mapper to map attributes down to the spawned subflow for access within the subflow");
            }
            return this.getAttributeMapper().createFlowInput(context);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No attribute mapper configured for this subflow state '" + this.getId() + "' -- As a result, no attributes will be passed to the spawned subflow '" + this.subflow.getId() + "'"));
        }
        return null;
    }

    public ViewSelection onEvent(RequestControlContext context) {
        this.mapSubflowOutput(context.getLastEvent().getAttributes(), context);
        return super.onEvent(context);
    }

    private void mapSubflowOutput(AttributeMap subflowOutput, RequestContext context) {
        if (this.getAttributeMapper() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Messaging the configured attribute mapper to map subflow result attributes to the resuming parent flow -- It will have access to attributes passed up by the completed subflow");
            }
            this.attributeMapper.mapFlowOutput(subflowOutput, context);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No attribute mapper is configured for the resuming subflow state '" + this.getId() + "' -- As a result, no attributes of the ending flow will be passed to the resuming parent flow"));
        }
    }

    protected void appendToString(ToStringCreator creator) {
        creator.append("subflow", (Object)this.subflow.getId()).append("attributeMapper", (Object)this.attributeMapper);
        super.appendToString(creator);
    }
}

