/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jca.support;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.XATerminator;
import jakarta.resource.spi.work.WorkManager;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jca.support.SimpleBootstrapContext;

public class ResourceAdapterFactoryBean
implements FactoryBean<ResourceAdapter>,
InitializingBean,
DisposableBean {
    private @Nullable ResourceAdapter resourceAdapter;
    private @Nullable BootstrapContext bootstrapContext;
    private @Nullable WorkManager workManager;
    private @Nullable XATerminator xaTerminator;

    public void setResourceAdapterClass(Class<? extends ResourceAdapter> resourceAdapterClass) {
        this.resourceAdapter = (ResourceAdapter)BeanUtils.instantiateClass(resourceAdapterClass);
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    public void setBootstrapContext(BootstrapContext bootstrapContext) {
        this.bootstrapContext = bootstrapContext;
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    public void setXaTerminator(XATerminator xaTerminator) {
        this.xaTerminator = xaTerminator;
    }

    public void afterPropertiesSet() throws ResourceException {
        if (this.resourceAdapter == null) {
            throw new IllegalArgumentException("'resourceAdapter' or 'resourceAdapterClass' is required");
        }
        if (this.bootstrapContext == null) {
            this.bootstrapContext = new SimpleBootstrapContext(this.workManager, this.xaTerminator);
        }
        this.resourceAdapter.start(this.bootstrapContext);
    }

    public @Nullable ResourceAdapter getObject() {
        return this.resourceAdapter;
    }

    public Class<? extends ResourceAdapter> getObjectType() {
        return this.resourceAdapter != null ? this.resourceAdapter.getClass() : ResourceAdapter.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        if (this.resourceAdapter != null) {
            this.resourceAdapter.stop();
        }
    }
}

