/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.aot;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

final class GeneratedMapUtils {
    private GeneratedMapUtils() {
    }

    static Map loadMap(String className, String methodName) {
        try {
            Class clazz = ClassUtils.forName((String)className, null);
            Method method = ReflectionUtils.findMethod((Class)clazz, (String)methodName);
            Assert.state((method != null ? 1 : 0) != 0, () -> "No %s() method found in %s".formatted(methodName, className));
            Map map = (Map)ReflectionUtils.invokeMethod((Method)method, null);
            return map != null ? Collections.unmodifiableMap(map) : Collections.emptyMap();
        }
        catch (IllegalStateException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to invoke %s() method on %s".formatted(methodName, className), ex);
        }
    }
}

