/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

final class EncoderDecoderMappingProvider
implements MappingProvider {
    private final Encoder<?> encoder;
    private final Decoder<?> decoder;

    public EncoderDecoderMappingProvider(Encoder<?> encoder, Decoder<?> decoder) {
        this.encoder = encoder;
        this.decoder = decoder;
    }

    public <T> @Nullable T map(Object source, Class<T> targetType, Configuration configuration) {
        return this.mapToTargetType(source, ResolvableType.forClass(targetType));
    }

    public <T> @Nullable T map(Object source, TypeRef<T> targetType, Configuration configuration) {
        return this.mapToTargetType(source, ResolvableType.forType((Type)targetType.getType()));
    }

    private <T> @Nullable T mapToTargetType(Object source, ResolvableType targetType) {
        DefaultDataBufferFactory bufferFactory = DefaultDataBufferFactory.sharedInstance;
        MimeType mimeType = MimeTypeUtils.APPLICATION_JSON;
        Map hints = Collections.emptyMap();
        DataBuffer buffer = this.encoder.encodeValue(source, (DataBufferFactory)bufferFactory, ResolvableType.forInstance((Object)source), mimeType, hints);
        return (T)this.decoder.decode(buffer, targetType, mimeType, hints);
    }
}

