/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.convention;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.context.bean.override.BeanOverrideHandler;
import org.springframework.test.context.bean.override.BeanOverrideStrategy;
import org.springframework.util.ReflectionUtils;

final class TestBeanOverrideHandler
extends BeanOverrideHandler {
    private final Method factoryMethod;

    TestBeanOverrideHandler(Field field, ResolvableType beanType, @Nullable String beanName, String contextName, BeanOverrideStrategy strategy, Method factoryMethod) {
        super(field, beanType, beanName, contextName, strategy);
        this.factoryMethod = factoryMethod;
    }

    @Override
    protected Object createOverrideInstance(String beanName, @Nullable BeanDefinition existingBeanDefinition, @Nullable Object existingBeanInstance) {
        try {
            ReflectionUtils.makeAccessible((Method)this.factoryMethod);
            return this.factoryMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new IllegalStateException("Failed to invoke @TestBean factory method: " + String.valueOf(this.factoryMethod), ex);
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        TestBeanOverrideHandler that = (TestBeanOverrideHandler)other;
        return Objects.equals(this.factoryMethod, that.factoryMethod);
    }

    @Override
    public int hashCode() {
        return this.factoryMethod.hashCode() * 29 + super.hashCode();
    }

    @Override
    public String toString() {
        return new ToStringCreator((Object)this).append("field", (Object)this.getField()).append("beanType", (Object)this.getBeanType()).append("beanName", (Object)this.getBeanName()).append("contextName", (Object)this.getContextName()).append("strategy", (Object)this.getStrategy()).append("factoryMethod", (Object)this.factoryMethod).toString();
    }
}

