/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.lang.Nullable;
import org.springframework.test.context.BootstrapContext;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactories;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.ContextHierarchy;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.TestContextBootstrapper;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.support.ActiveProfilesUtils;
import org.springframework.test.context.support.ApplicationContextInitializerUtils;
import org.springframework.test.context.support.ContextLoaderUtils;
import org.springframework.test.context.support.DefaultTestContext;
import org.springframework.test.context.support.MergedTestPropertySources;
import org.springframework.test.context.support.TestPropertySourceUtils;
import org.springframework.test.context.util.TestContextSpringFactoriesUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractTestContextBootstrapper
implements TestContextBootstrapper {
    private final Log logger = LogFactory.getLog(this.getClass());
    @Nullable
    private BootstrapContext bootstrapContext;

    @Override
    public void setBootstrapContext(BootstrapContext bootstrapContext) {
        this.bootstrapContext = bootstrapContext;
    }

    @Override
    public BootstrapContext getBootstrapContext() {
        Assert.state((this.bootstrapContext != null ? 1 : 0) != 0, (String)"No BootstrapContext set");
        return this.bootstrapContext;
    }

    @Override
    public TestContext buildTestContext() {
        return new DefaultTestContext(this.getBootstrapContext().getTestClass(), this.buildMergedContextConfiguration(), this.getCacheAwareContextLoaderDelegate());
    }

    @Override
    public final List<TestExecutionListener> getTestExecutionListeners() {
        Class<?> clazz = this.getBootstrapContext().getTestClass();
        Class<TestExecutionListeners> annotationType = TestExecutionListeners.class;
        ArrayList<TestExecutionListener> listeners = new ArrayList<TestExecutionListener>(8);
        boolean usingDefaults = false;
        TestContextAnnotationUtils.AnnotationDescriptor<TestExecutionListeners> descriptor = TestContextAnnotationUtils.findAnnotationDescriptor(clazz, annotationType);
        if (descriptor == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)String.format("@TestExecutionListeners is not present for class [%s]: using defaults.", clazz.getName()));
            }
            usingDefaults = true;
            listeners.addAll(this.getDefaultTestExecutionListeners());
        } else {
            while (descriptor != null) {
                Class<?> declaringClass = descriptor.getDeclaringClass();
                TestExecutionListeners testExecutionListeners = descriptor.getAnnotation();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)String.format("Retrieved @TestExecutionListeners [%s] for declaring class [%s].", testExecutionListeners, declaringClass.getName()));
                }
                boolean inheritListeners = testExecutionListeners.inheritListeners();
                TestContextAnnotationUtils.AnnotationDescriptor<TestExecutionListeners> parentDescriptor = descriptor.next();
                if (!(inheritListeners && parentDescriptor != null || testExecutionListeners.mergeMode() != TestExecutionListeners.MergeMode.MERGE_WITH_DEFAULTS)) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)String.format("Merging default listeners with listeners configured via @TestExecutionListeners for class [%s].", descriptor.getRootDeclaringClass().getName()));
                    }
                    usingDefaults = true;
                    listeners.addAll(this.getDefaultTestExecutionListeners());
                }
                listeners.addAll(0, this.instantiateListeners(testExecutionListeners.listeners()));
                descriptor = inheritListeners ? parentDescriptor : null;
            }
        }
        if (usingDefaults) {
            ArrayList uniqueListeners = new ArrayList(listeners.size());
            listeners.forEach(listener -> {
                Class<?> listenerClass = listener.getClass();
                if (uniqueListeners.stream().map(Object::getClass).noneMatch(listenerClass::equals)) {
                    uniqueListeners.add(listener);
                }
            });
            listeners = uniqueListeners;
            AnnotationAwareOrderComparator.sort(listeners);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Using TestExecutionListeners for test class [%s]: %s".formatted(clazz.getName(), listeners));
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Using TestExecutionListeners for test class [%s]: %s".formatted(clazz.getSimpleName(), AbstractTestContextBootstrapper.classSimpleNames(listeners)));
        }
        return listeners;
    }

    private List<TestExecutionListener> instantiateListeners(Class<? extends TestExecutionListener> ... classes) {
        return this.instantiateComponents(TestExecutionListener.class, classes);
    }

    protected List<TestExecutionListener> getDefaultTestExecutionListeners() {
        return TestContextSpringFactoriesUtils.loadFactoryImplementations(TestExecutionListener.class);
    }

    @Override
    public final MergedContextConfiguration buildMergedContextConfiguration() {
        Class<?> testClass = this.getBootstrapContext().getTestClass();
        CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate = this.getCacheAwareContextLoaderDelegate();
        if (TestContextAnnotationUtils.findAnnotationDescriptorForTypes(testClass, ContextConfiguration.class, ContextHierarchy.class) == null) {
            return this.buildDefaultMergedContextConfiguration(testClass, cacheAwareContextLoaderDelegate);
        }
        if (TestContextAnnotationUtils.findAnnotationDescriptor(testClass, ContextHierarchy.class) != null) {
            Map<String, List<ContextConfigurationAttributes>> hierarchyMap = ContextLoaderUtils.buildContextHierarchyMap(testClass);
            MergedContextConfiguration parentConfig = null;
            MergedContextConfiguration mergedConfig = null;
            for (List<ContextConfigurationAttributes> list : hierarchyMap.values()) {
                ArrayList<ContextConfigurationAttributes> reversedList = new ArrayList<ContextConfigurationAttributes>(list);
                Collections.reverse(reversedList);
                Assert.notEmpty(reversedList, (String)"ContextConfigurationAttributes list must not be empty");
                Class<?> declaringClass = ((ContextConfigurationAttributes)reversedList.get(0)).getDeclaringClass();
                parentConfig = mergedConfig = this.buildMergedContextConfiguration(declaringClass, reversedList, parentConfig, cacheAwareContextLoaderDelegate, true);
            }
            Assert.state((mergedConfig != null ? 1 : 0) != 0, (String)"No merged context configuration");
            return mergedConfig;
        }
        return this.buildMergedContextConfiguration(testClass, ContextLoaderUtils.resolveContextConfigurationAttributes(testClass), null, cacheAwareContextLoaderDelegate, true);
    }

    private MergedContextConfiguration buildDefaultMergedContextConfiguration(Class<?> testClass, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate) {
        List<ContextConfigurationAttributes> defaultConfigAttributesList = Collections.singletonList(new ContextConfigurationAttributes(testClass));
        ContextLoader contextLoader = this.resolveContextLoader(testClass, defaultConfigAttributesList);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)String.format("Neither @ContextConfiguration nor @ContextHierarchy found for test class [%s]: using %s", testClass.getName(), contextLoader.getClass().getName()));
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Neither @ContextConfiguration nor @ContextHierarchy found for test class [%s]: using %s", testClass.getSimpleName(), contextLoader.getClass().getSimpleName()));
        }
        return this.buildMergedContextConfiguration(testClass, defaultConfigAttributesList, null, cacheAwareContextLoaderDelegate, false);
    }

    private MergedContextConfiguration buildMergedContextConfiguration(Class<?> testClass, List<ContextConfigurationAttributes> configAttributesList, @Nullable MergedContextConfiguration parentConfig, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate, boolean requireLocationsClassesOrInitializers) {
        Assert.notEmpty(configAttributesList, (String)"ContextConfigurationAttributes list must not be null or empty");
        ContextLoader contextLoader = this.resolveContextLoader(testClass, configAttributesList);
        ArrayList<String> locations = new ArrayList<String>();
        ArrayList classes = new ArrayList();
        ArrayList initializers = new ArrayList();
        for (ContextConfigurationAttributes configAttributes : configAttributesList) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)String.format("Processing locations and classes for context configuration attributes %s", configAttributes));
            }
            if (contextLoader instanceof SmartContextLoader) {
                SmartContextLoader smartContextLoader = (SmartContextLoader)contextLoader;
                smartContextLoader.processContextConfiguration(configAttributes);
                locations.addAll(0, Arrays.asList(configAttributes.getLocations()));
                classes.addAll(0, Arrays.asList(configAttributes.getClasses()));
            } else {
                String[] processedLocations = contextLoader.processLocations(configAttributes.getDeclaringClass(), configAttributes.getLocations());
                locations.addAll(0, Arrays.asList(processedLocations));
            }
            initializers.addAll(0, Arrays.asList(configAttributes.getInitializers()));
            if (configAttributes.isInheritLocations()) continue;
            break;
        }
        Set<ContextCustomizer> contextCustomizers = this.getContextCustomizers(testClass, Collections.unmodifiableList(configAttributesList));
        Assert.state((!requireLocationsClassesOrInitializers || !AbstractTestContextBootstrapper.areAllEmpty(locations, classes, initializers, contextCustomizers) ? 1 : 0) != 0, () -> String.format("%s was unable to detect defaults, and no ApplicationContextInitializers or ContextCustomizers were declared for context configuration attributes %s", contextLoader.getClass().getSimpleName(), configAttributesList));
        MergedTestPropertySources mergedTestPropertySources = TestPropertySourceUtils.buildMergedTestPropertySources(testClass);
        MergedContextConfiguration mergedConfig = new MergedContextConfiguration(testClass, StringUtils.toStringArray(locations), ClassUtils.toClassArray(classes), ApplicationContextInitializerUtils.resolveInitializerClasses(configAttributesList), ActiveProfilesUtils.resolveActiveProfiles(testClass), mergedTestPropertySources.getPropertySourceDescriptors(), mergedTestPropertySources.getProperties(), contextCustomizers, contextLoader, cacheAwareContextLoaderDelegate, parentConfig);
        return this.processMergedContextConfiguration(mergedConfig);
    }

    private Set<ContextCustomizer> getContextCustomizers(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        List<ContextCustomizerFactory> factories = this.getContextCustomizerFactories(testClass);
        LinkedHashSet customizers = CollectionUtils.newLinkedHashSet((int)factories.size());
        for (ContextCustomizerFactory factory : factories) {
            ContextCustomizer customizer = factory.createContextCustomizer(testClass, configAttributes);
            if (customizer == null) continue;
            customizers.add(customizer);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Using ContextCustomizers for test class [%s]: %s".formatted(testClass.getName(), customizers));
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Using ContextCustomizers for test class [%s]: %s".formatted(testClass.getSimpleName(), AbstractTestContextBootstrapper.classSimpleNames(customizers)));
        }
        return customizers;
    }

    private List<ContextCustomizerFactory> getContextCustomizerFactories(Class<?> testClass) {
        TestContextAnnotationUtils.AnnotationDescriptor<ContextCustomizerFactories> descriptor = TestContextAnnotationUtils.findAnnotationDescriptor(testClass, ContextCustomizerFactories.class);
        ArrayList<ContextCustomizerFactory> factories = new ArrayList<ContextCustomizerFactory>();
        if (descriptor == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"@ContextCustomizerFactories is not present for class [%s]".formatted(testClass.getName()));
            }
            factories.addAll(this.getContextCustomizerFactories());
        } else {
            while (descriptor != null) {
                Class<?> declaringClass = descriptor.getDeclaringClass();
                ContextCustomizerFactories annotation = descriptor.getAnnotation();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Retrieved %s for declaring class [%s].".formatted(annotation, declaringClass.getName()));
                }
                boolean inheritFactories = annotation.inheritFactories();
                TestContextAnnotationUtils.AnnotationDescriptor<ContextCustomizerFactories> parentDescriptor = descriptor.next();
                factories.addAll(0, this.instantiateCustomizerFactories(annotation.factories()));
                if (!(inheritFactories && parentDescriptor != null || annotation.mergeMode() != ContextCustomizerFactories.MergeMode.MERGE_WITH_DEFAULTS)) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)String.format("Merging default factories with factories configured via @ContextCustomizerFactories for class [%s].", descriptor.getRootDeclaringClass().getName()));
                    }
                    factories.addAll(0, this.getContextCustomizerFactories());
                }
                descriptor = inheritFactories ? parentDescriptor : null;
            }
        }
        ArrayList uniqueFactories = new ArrayList(factories.size());
        factories.forEach(factory -> {
            Class<?> factoryClass = factory.getClass();
            if (uniqueFactories.stream().map(Object::getClass).noneMatch(factoryClass::equals)) {
                uniqueFactories.add(factory);
            }
        });
        factories = uniqueFactories;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Using ContextCustomizerFactory implementations for test class [%s]: %s".formatted(testClass.getName(), factories));
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Using ContextCustomizerFactory implementations for test class [%s]: %s".formatted(testClass.getSimpleName(), AbstractTestContextBootstrapper.classSimpleNames(factories)));
        }
        return factories;
    }

    protected List<ContextCustomizerFactory> getContextCustomizerFactories() {
        return TestContextSpringFactoriesUtils.loadFactoryImplementations(ContextCustomizerFactory.class);
    }

    private List<ContextCustomizerFactory> instantiateCustomizerFactories(Class<? extends ContextCustomizerFactory> ... classes) {
        return this.instantiateComponents(ContextCustomizerFactory.class, classes);
    }

    private <T> List<T> instantiateComponents(Class<T> componentType, Class<? extends T> ... classes) {
        ArrayList<Object> components = new ArrayList<Object>(classes.length);
        for (Class<T> clazz : classes) {
            try {
                components.add(BeanUtils.instantiateClass(clazz));
            }
            catch (BeanInstantiationException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof ClassNotFoundException || cause instanceof NoClassDefFoundError) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)"Skipping candidate %1$s [%2$s] due to a missing dependency. Specify custom %1$s classes or make the default %1$s classes and their required dependencies available. Offending class: [%3$s]".formatted(componentType.getSimpleName(), clazz.getName(), cause.getMessage()));
                    continue;
                }
                throw ex;
            }
        }
        return components;
    }

    protected ContextLoader resolveContextLoader(Class<?> testClass, List<ContextConfigurationAttributes> configAttributesList) {
        Assert.notNull(testClass, (String)"Class must not be null");
        Assert.notNull(configAttributesList, (String)"ContextConfigurationAttributes list must not be null");
        Class<? extends ContextLoader> contextLoaderClass = this.resolveExplicitContextLoaderClass(configAttributesList);
        if (contextLoaderClass == null) {
            contextLoaderClass = this.getDefaultContextLoaderClass(testClass);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)String.format("Using ContextLoader class [%s] for test class [%s]", contextLoaderClass.getName(), testClass.getName()));
        }
        return (ContextLoader)BeanUtils.instantiateClass(contextLoaderClass, ContextLoader.class);
    }

    @Nullable
    protected Class<? extends ContextLoader> resolveExplicitContextLoaderClass(List<ContextConfigurationAttributes> configAttributesList) {
        Assert.notNull(configAttributesList, (String)"ContextConfigurationAttributes list must not be null");
        for (ContextConfigurationAttributes configAttributes : configAttributesList) {
            Class<? extends ContextLoader> contextLoaderClass;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Resolving ContextLoader for context configuration attributes " + String.valueOf(configAttributes)));
            }
            if (ContextLoader.class == (contextLoaderClass = configAttributes.getContextLoaderClass())) continue;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Found explicit ContextLoader class [%s] for context configuration attributes %s".formatted(contextLoaderClass.getName(), configAttributes));
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Found explicit ContextLoader class [%s] for test class [%s]".formatted(contextLoaderClass.getSimpleName(), configAttributes.getDeclaringClass().getSimpleName()));
            }
            return contextLoaderClass;
        }
        return null;
    }

    protected CacheAwareContextLoaderDelegate getCacheAwareContextLoaderDelegate() {
        return this.getBootstrapContext().getCacheAwareContextLoaderDelegate();
    }

    protected abstract Class<? extends ContextLoader> getDefaultContextLoaderClass(Class<?> var1);

    protected MergedContextConfiguration processMergedContextConfiguration(MergedContextConfiguration mergedConfig) {
        return mergedConfig;
    }

    private static List<String> classSimpleNames(Collection<?> components) {
        return components.stream().map(Object::getClass).map(Class::getSimpleName).toList();
    }

    private static boolean areAllEmpty(Collection<?> ... collections) {
        return Arrays.stream(collections).allMatch(Collection::isEmpty);
    }
}

