/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.core;

import java.util.List;
import org.springframework.r2dbc.core.BindParameterSource;
import org.springframework.r2dbc.core.NamedParameterUtils;
import org.springframework.r2dbc.core.ParsedSql;
import org.springframework.r2dbc.core.PreparedOperation;
import org.springframework.r2dbc.core.binding.BindMarkersFactory;
import org.springframework.util.ConcurrentLruCache;

class NamedParameterExpander {
    public static final int DEFAULT_CACHE_LIMIT = 256;
    private final ConcurrentLruCache<String, ParsedSql> parsedSqlCache = new ConcurrentLruCache(256, NamedParameterUtils::parseSqlStatement);

    NamedParameterExpander() {
    }

    private ParsedSql getParsedSql(String sql) {
        return (ParsedSql)this.parsedSqlCache.get((Object)sql);
    }

    public PreparedOperation<String> expand(String sql, BindMarkersFactory bindMarkersFactory, BindParameterSource paramSource) {
        ParsedSql parsedSql = this.getParsedSql(sql);
        return NamedParameterUtils.substituteNamedParameters(parsedSql, bindMarkersFactory, paramSource);
    }

    public List<String> getParameterNames(String sql) {
        return this.getParsedSql(sql).getParameterNames();
    }
}

