/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.core;

import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.jspecify.annotations.Nullable;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class ColumnMapRowMapper
implements BiFunction<Row, RowMetadata, Map<String, Object>> {
    public static final ColumnMapRowMapper INSTANCE = new ColumnMapRowMapper();

    @Override
    public Map<String, Object> apply(Row row, RowMetadata rowMetadata) {
        List columns = rowMetadata.getColumnMetadatas();
        int columnCount = columns.size();
        Map<String, Object> mapOfColValues = this.createColumnMap(columnCount);
        int index = 0;
        for (ColumnMetadata column : columns) {
            String key = this.getColumnKey(column.getName());
            Object obj = this.getColumnValue(row, index++);
            mapOfColValues.put(key, obj);
        }
        return mapOfColValues;
    }

    protected Map<String, Object> createColumnMap(int columnCount) {
        return new LinkedCaseInsensitiveMap(columnCount);
    }

    protected String getColumnKey(String columnName) {
        return columnName;
    }

    protected @Nullable Object getColumnValue(Row row, int index) {
        return row.get(index);
    }
}

