/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.core.binding;

import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.core.binding.BindMarkersFactory;
import org.springframework.util.LinkedCaseInsensitiveMap;

public final class BindMarkersFactoryResolver {
    private static final List<BindMarkerFactoryProvider> DETECTORS = SpringFactoriesLoader.loadFactories(BindMarkerFactoryProvider.class, (ClassLoader)BindMarkersFactoryResolver.class.getClassLoader());

    public static BindMarkersFactory resolve(ConnectionFactory connectionFactory) {
        for (BindMarkerFactoryProvider detector : DETECTORS) {
            BindMarkersFactory bindMarkersFactory = detector.getBindMarkers(connectionFactory);
            if (bindMarkersFactory == null) continue;
            return bindMarkersFactory;
        }
        throw new NoBindMarkersFactoryException(String.format("Cannot determine a BindMarkersFactory for %s using %s", connectionFactory.getMetadata().getName(), connectionFactory));
    }

    private BindMarkersFactoryResolver() {
    }

    static class BuiltInBindMarkersFactoryProvider
    implements BindMarkerFactoryProvider {
        private static final Map<String, BindMarkersFactory> BUILTIN = new LinkedCaseInsensitiveMap(Locale.ENGLISH);

        BuiltInBindMarkersFactoryProvider() {
        }

        @Override
        public BindMarkersFactory getBindMarkers(ConnectionFactory connectionFactory) {
            ConnectionFactoryMetadata metadata = connectionFactory.getMetadata();
            BindMarkersFactory r2dbcDialect = BUILTIN.get(metadata.getName());
            if (r2dbcDialect != null) {
                return r2dbcDialect;
            }
            for (String it : BUILTIN.keySet()) {
                if (!metadata.getName().contains(it)) continue;
                return BUILTIN.get(it);
            }
            return null;
        }

        private static String filterBindMarker(CharSequence input) {
            StringBuilder builder = new StringBuilder(input.length());
            for (int i = 0; i < input.length(); ++i) {
                char ch = input.charAt(i);
                if (!Character.isLetterOrDigit(ch) || ch >= '\u007f') continue;
                builder.append(ch);
            }
            if (builder.length() == 0) {
                return "";
            }
            return "_" + builder.toString();
        }

        static {
            BUILTIN.put("H2", BindMarkersFactory.indexed("$", 1));
            BUILTIN.put("MariaDB", BindMarkersFactory.anonymous("?"));
            BUILTIN.put("Microsoft SQL Server", BindMarkersFactory.named("@", "P", 32, BuiltInBindMarkersFactoryProvider::filterBindMarker));
            BUILTIN.put("MySQL", BindMarkersFactory.anonymous("?"));
            BUILTIN.put("Oracle", BindMarkersFactory.named(":", "P", 32, BuiltInBindMarkersFactoryProvider::filterBindMarker));
            BUILTIN.put("PostgreSQL", BindMarkersFactory.indexed("$", 1));
        }
    }

    public static class NoBindMarkersFactoryException
    extends NonTransientDataAccessException {
        public NoBindMarkersFactoryException(String msg) {
            super(msg);
        }
    }

    @FunctionalInterface
    public static interface BindMarkerFactoryProvider {
        @Nullable
        public BindMarkersFactory getBindMarkers(ConnectionFactory var1);
    }
}

