/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.stomp;

import java.util.concurrent.CompletableFuture;
import org.jspecify.annotations.Nullable;
import org.springframework.messaging.simp.SimpLogging;
import org.springframework.messaging.simp.stomp.ConnectionHandlingStompSession;
import org.springframework.messaging.simp.stomp.StompClientSupport;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompReactorNettyCodec;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.messaging.tcp.TcpOperations;
import org.springframework.messaging.tcp.reactor.ReactorNettyTcpClient;
import org.springframework.util.Assert;

public class ReactorNettyTcpStompClient
extends StompClientSupport {
    private final TcpOperations<byte[]> tcpClient;

    public ReactorNettyTcpStompClient() {
        this("127.0.0.1", 61613);
    }

    public ReactorNettyTcpStompClient(String host, int port) {
        this.tcpClient = ReactorNettyTcpStompClient.initTcpClient(host, port);
    }

    public ReactorNettyTcpStompClient(TcpOperations<byte[]> tcpClient) {
        Assert.notNull(tcpClient, (String)"'tcpClient' is required");
        this.tcpClient = tcpClient;
    }

    private static TcpOperations<byte[]> initTcpClient(String host, int port) {
        ReactorNettyTcpClient<byte[]> client = new ReactorNettyTcpClient<byte[]>(host, port, new StompReactorNettyCodec());
        client.setLogger(SimpLogging.forLog(client.getLogger()));
        return client;
    }

    public CompletableFuture<StompSession> connectAsync(StompSessionHandler handler) {
        return this.connectAsync(null, handler);
    }

    public CompletableFuture<StompSession> connectAsync(@Nullable StompHeaders connectHeaders, StompSessionHandler handler) {
        ConnectionHandlingStompSession session = this.createSession(connectHeaders, handler);
        this.tcpClient.connectAsync(session);
        return session.getSession();
    }

    public void shutdown() {
        this.tcpClient.shutdownAsync();
    }

    public String toString() {
        return "ReactorNettyTcpStompClient[" + String.valueOf(this.tcpClient) + "]";
    }
}

