/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.core;

import io.micrometer.jakarta9.instrument.jms.JmsInstrumentation;
import io.micrometer.observation.ObservationRegistry;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import org.jspecify.annotations.Nullable;
import org.springframework.jms.JmsException;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.connection.JmsResourceHolder;
import org.springframework.jms.core.BrowserCallback;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.core.MessagePostProcessor;
import org.springframework.jms.core.ProducerCallback;
import org.springframework.jms.core.SessionCallback;
import org.springframework.jms.support.JmsAccessor;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.QosSettings;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.jms.support.destination.JmsDestinationAccessor;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class JmsTemplate
extends JmsDestinationAccessor
implements JmsOperations {
    private static final boolean MICROMETER_JAKARTA_PRESENT = ClassUtils.isPresent((String)"io.micrometer.jakarta9.instrument.jms.JmsInstrumentation", (ClassLoader)JmsTemplate.class.getClassLoader());
    private final JmsTemplateResourceFactory transactionalResourceFactory = new JmsTemplateResourceFactory();
    private @Nullable Object defaultDestination;
    private MessageConverter messageConverter = new SimpleMessageConverter();
    private boolean messageIdEnabled = true;
    private boolean messageTimestampEnabled = true;
    private boolean pubSubNoLocal = false;
    private long receiveTimeout = 0L;
    private long deliveryDelay = -1L;
    private boolean explicitQosEnabled = false;
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    private @Nullable ObservationRegistry observationRegistry;

    public JmsTemplate() {
    }

    public JmsTemplate(ConnectionFactory connectionFactory) {
        this.setConnectionFactory(connectionFactory);
        this.afterPropertiesSet();
    }

    public JmsTemplate(JmsAccessor original) {
        this.setConnectionFactory(original.getConnectionFactory());
        this.setSessionTransacted(original.isSessionTransacted());
        this.setSessionAcknowledgeMode(original.getSessionAcknowledgeMode());
        if (original instanceof JmsDestinationAccessor) {
            JmsDestinationAccessor destinationAccessor = (JmsDestinationAccessor)original;
            this.setDestinationResolver(destinationAccessor.getDestinationResolver());
            this.setPubSubDomain(destinationAccessor.isPubSubDomain());
        }
        if (original instanceof JmsTemplate) {
            JmsTemplate originalTemplate = (JmsTemplate)original;
            this.setDefaultDestination(originalTemplate.getDefaultDestination());
            this.setMessageConverter(originalTemplate.getMessageConverter());
            this.setMessageIdEnabled(originalTemplate.isMessageIdEnabled());
            this.setMessageTimestampEnabled(originalTemplate.isMessageTimestampEnabled());
            this.setPubSubNoLocal(originalTemplate.isPubSubNoLocal());
            this.setReceiveTimeout(originalTemplate.getReceiveTimeout());
            this.setDeliveryDelay(originalTemplate.getDeliveryDelay());
            this.setExplicitQosEnabled(originalTemplate.isExplicitQosEnabled());
            this.setDeliveryMode(originalTemplate.getDeliveryMode());
            this.setPriority(originalTemplate.getPriority());
            this.setTimeToLive(originalTemplate.getTimeToLive());
            this.setObservationRegistry(originalTemplate.getObservationRegistry());
        }
    }

    public void setDefaultDestination(@Nullable Destination destination) {
        this.defaultDestination = destination;
    }

    public @Nullable Destination getDefaultDestination() {
        Destination dest;
        Object object = this.defaultDestination;
        return object instanceof Destination ? (dest = (Destination)object) : null;
    }

    private @Nullable Queue getDefaultQueue() {
        Destination defaultDestination = this.getDefaultDestination();
        if (defaultDestination == null) {
            return null;
        }
        if (!(defaultDestination instanceof Queue)) {
            throw new IllegalStateException("'defaultDestination' does not correspond to a Queue. Check configuration of JmsTemplate.");
        }
        Queue queue = (Queue)defaultDestination;
        return queue;
    }

    public void setDefaultDestinationName(@Nullable String destinationName) {
        this.defaultDestination = destinationName;
    }

    public @Nullable String getDefaultDestinationName() {
        String name;
        Object object = this.defaultDestination;
        return object instanceof String ? (name = (String)object) : null;
    }

    private String getRequiredDefaultDestinationName() throws IllegalStateException {
        String name = this.getDefaultDestinationName();
        if (name == null) {
            throw new IllegalStateException("No 'defaultDestination' or 'defaultDestinationName' specified. Check configuration of JmsTemplate.");
        }
        return name;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"MessageConverter must not be null");
        this.messageConverter = messageConverter;
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageIdEnabled(boolean messageIdEnabled) {
        this.messageIdEnabled = messageIdEnabled;
    }

    public boolean isMessageIdEnabled() {
        return this.messageIdEnabled;
    }

    public void setMessageTimestampEnabled(boolean messageTimestampEnabled) {
        this.messageTimestampEnabled = messageTimestampEnabled;
    }

    public boolean isMessageTimestampEnabled() {
        return this.messageTimestampEnabled;
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    public boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setDeliveryDelay(long deliveryDelay) {
        this.deliveryDelay = deliveryDelay;
    }

    public long getDeliveryDelay() {
        return this.deliveryDelay;
    }

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.explicitQosEnabled = explicitQosEnabled;
    }

    public boolean isExplicitQosEnabled() {
        return this.explicitQosEnabled;
    }

    public void setQosSettings(QosSettings settings) {
        Assert.notNull((Object)settings, (String)"Settings must not be null");
        this.setExplicitQosEnabled(true);
        this.setDeliveryMode(settings.getDeliveryMode());
        this.setPriority(settings.getPriority());
        this.setTimeToLive(settings.getTimeToLive());
    }

    public void setDeliveryPersistent(boolean deliveryPersistent) {
        this.deliveryMode = deliveryPersistent ? 2 : 1;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setObservationRegistry(@Nullable ObservationRegistry observationRegistry) {
        this.observationRegistry = observationRegistry;
    }

    public @Nullable ObservationRegistry getObservationRegistry() {
        return this.observationRegistry;
    }

    @Override
    public <T> @Nullable T execute(SessionCallback<T> action) throws JmsException {
        return this.execute(action, false);
    }

    public <T> @Nullable T execute(SessionCallback<T> action, boolean startConnection) throws JmsException {
        T t;
        Assert.notNull(action, (String)"Callback object must not be null");
        Connection conToClose = null;
        Session sessionToClose = null;
        try {
            Session sessionToUse = ConnectionFactoryUtils.doGetTransactionalSession(this.obtainConnectionFactory(), this.transactionalResourceFactory, startConnection);
            if (sessionToUse == null) {
                conToClose = this.createConnection();
                sessionToClose = this.createSession(conToClose);
                if (startConnection) {
                    conToClose.start();
                }
                sessionToUse = sessionToClose;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executing callback on JMS Session: " + String.valueOf(sessionToUse)));
            }
            if (MICROMETER_JAKARTA_PRESENT && this.observationRegistry != null) {
                sessionToUse = MicrometerInstrumentation.instrumentSession(sessionToUse, this.observationRegistry);
            }
            t = action.doInJms(sessionToUse);
        }
        catch (JMSException ex) {
            try {
                throw this.convertJmsAccessException(ex);
            }
            catch (Throwable throwable) {
                JmsUtils.closeSession(sessionToClose);
                ConnectionFactoryUtils.releaseConnection(conToClose, this.getConnectionFactory(), startConnection);
                throw throwable;
            }
        }
        JmsUtils.closeSession(sessionToClose);
        ConnectionFactoryUtils.releaseConnection(conToClose, this.getConnectionFactory(), startConnection);
        return t;
    }

    @Override
    public <T> @Nullable T execute(ProducerCallback<T> action) throws JmsException {
        String defaultDestinationName = this.getDefaultDestinationName();
        if (defaultDestinationName != null) {
            return this.execute(defaultDestinationName, action);
        }
        return this.execute(this.getDefaultDestination(), action);
    }

    @Override
    public <T> @Nullable T execute(@Nullable Destination destination, ProducerCallback<T> action) throws JmsException {
        Assert.notNull(action, (String)"Callback object must not be null");
        return (T)this.execute((Session session) -> {
            MessageProducer producer = this.createProducer(session, destination);
            try {
                Object t = action.doInJms(session, producer);
                return t;
            }
            finally {
                JmsUtils.closeMessageProducer(producer);
            }
        }, false);
    }

    @Override
    public <T> @Nullable T execute(String destinationName, ProducerCallback<T> action) throws JmsException {
        Assert.notNull(action, (String)"Callback object must not be null");
        return (T)this.execute((Session session) -> {
            Destination destination = this.resolveDestinationName(session, destinationName);
            MessageProducer producer = this.createProducer(session, destination);
            try {
                Object t = action.doInJms(session, producer);
                return t;
            }
            finally {
                JmsUtils.closeMessageProducer(producer);
            }
        }, false);
    }

    @Override
    public void send(MessageCreator messageCreator) throws JmsException {
        Destination defaultDestination = this.getDefaultDestination();
        if (defaultDestination != null) {
            this.send(defaultDestination, messageCreator);
        } else {
            this.send(this.getRequiredDefaultDestinationName(), messageCreator);
        }
    }

    @Override
    public void send(Destination destination, MessageCreator messageCreator) throws JmsException {
        this.execute((Session session) -> {
            this.doSend(session, destination, messageCreator);
            return null;
        }, false);
    }

    @Override
    public void send(String destinationName, MessageCreator messageCreator) throws JmsException {
        this.execute((Session session) -> {
            Destination destination = this.resolveDestinationName(session, destinationName);
            this.doSend(session, destination, messageCreator);
            return null;
        }, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSend(Session session, Destination destination, MessageCreator messageCreator) throws JMSException {
        Assert.notNull((Object)messageCreator, (String)"MessageCreator must not be null");
        MessageProducer producer = this.createProducer(session, destination);
        try {
            Message message = messageCreator.createMessage(session);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Sending created message: " + String.valueOf(message)));
            }
            this.doSend(producer, message);
            if (session.getTransacted() && this.isSessionLocallyTransacted(session)) {
                JmsUtils.commitIfNecessary(session);
            }
        }
        finally {
            JmsUtils.closeMessageProducer(producer);
        }
    }

    protected void doSend(MessageProducer producer, Message message) throws JMSException {
        if (this.deliveryDelay >= 0L) {
            producer.setDeliveryDelay(this.deliveryDelay);
        }
        if (this.isExplicitQosEnabled()) {
            producer.send(message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
        } else {
            producer.send(message);
        }
    }

    @Override
    public void convertAndSend(Object message) throws JmsException {
        Destination defaultDestination = this.getDefaultDestination();
        if (defaultDestination != null) {
            this.convertAndSend(defaultDestination, message);
        } else {
            this.convertAndSend(this.getRequiredDefaultDestinationName(), message);
        }
    }

    @Override
    public void convertAndSend(Destination destination, Object message) throws JmsException {
        this.send(destination, (Session session) -> this.getMessageConverter().toMessage(message, session));
    }

    @Override
    public void convertAndSend(String destinationName, Object message) throws JmsException {
        this.send(destinationName, (Session session) -> this.getMessageConverter().toMessage(message, session));
    }

    @Override
    public void convertAndSend(Object message, MessagePostProcessor postProcessor) throws JmsException {
        Destination defaultDestination = this.getDefaultDestination();
        if (defaultDestination != null) {
            this.convertAndSend(defaultDestination, message, postProcessor);
        } else {
            this.convertAndSend(this.getRequiredDefaultDestinationName(), message, postProcessor);
        }
    }

    @Override
    public void convertAndSend(Destination destination, Object message, MessagePostProcessor postProcessor) throws JmsException {
        this.send(destination, (Session session) -> {
            Message msg = this.getMessageConverter().toMessage(message, session);
            return postProcessor.postProcessMessage(msg);
        });
    }

    @Override
    public void convertAndSend(String destinationName, Object message, MessagePostProcessor postProcessor) throws JmsException {
        this.send(destinationName, (Session session) -> {
            Message msg = this.getMessageConverter().toMessage(message, session);
            return postProcessor.postProcessMessage(msg);
        });
    }

    @Override
    public @Nullable Message receive() throws JmsException {
        Destination defaultDestination = this.getDefaultDestination();
        if (defaultDestination != null) {
            return this.receive(defaultDestination);
        }
        return this.receive(this.getRequiredDefaultDestinationName());
    }

    @Override
    public @Nullable Message receive(Destination destination) throws JmsException {
        return this.receiveSelected(destination, null);
    }

    @Override
    public @Nullable Message receive(String destinationName) throws JmsException {
        return this.receiveSelected(destinationName, null);
    }

    @Override
    public @Nullable Message receiveSelected(@Nullable String messageSelector) throws JmsException {
        Destination defaultDestination = this.getDefaultDestination();
        if (defaultDestination != null) {
            return this.receiveSelected(defaultDestination, messageSelector);
        }
        return this.receiveSelected(this.getRequiredDefaultDestinationName(), messageSelector);
    }

    @Override
    public @Nullable Message receiveSelected(Destination destination, @Nullable String messageSelector) throws JmsException {
        return this.execute((Session session) -> this.doReceive(session, destination, messageSelector), true);
    }

    @Override
    public @Nullable Message receiveSelected(String destinationName, @Nullable String messageSelector) throws JmsException {
        return this.execute((Session session) -> {
            Destination destination = this.resolveDestinationName(session, destinationName);
            return this.doReceive(session, destination, messageSelector);
        }, true);
    }

    protected @Nullable Message doReceive(Session session, Destination destination, @Nullable String messageSelector) throws JMSException {
        return this.doReceive(session, this.createConsumer(session, destination, messageSelector));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @Nullable Message doReceive(Session session, MessageConsumer consumer) throws JMSException {
        try {
            long timeout = this.getReceiveTimeout();
            ConnectionFactory connectionFactory = this.getConnectionFactory();
            JmsResourceHolder resourceHolder = null;
            if (connectionFactory != null) {
                resourceHolder = (JmsResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)connectionFactory));
            }
            if (resourceHolder != null && resourceHolder.hasTimeout()) {
                timeout = Math.min(timeout, resourceHolder.getTimeToLiveInMillis());
            }
            Message message = this.receiveFromConsumer(consumer, timeout);
            if (session.getTransacted()) {
                if (this.isSessionLocallyTransacted(session)) {
                    JmsUtils.commitIfNecessary(session);
                }
            } else if (this.isClientAcknowledge(session) && message != null) {
                message.acknowledge();
            }
            Message message2 = message;
            return message2;
        }
        finally {
            JmsUtils.closeMessageConsumer(consumer);
        }
    }

    @Override
    public @Nullable Object receiveAndConvert() throws JmsException {
        return this.doConvertFromMessage(this.receive());
    }

    @Override
    public @Nullable Object receiveAndConvert(Destination destination) throws JmsException {
        return this.doConvertFromMessage(this.receive(destination));
    }

    @Override
    public @Nullable Object receiveAndConvert(String destinationName) throws JmsException {
        return this.doConvertFromMessage(this.receive(destinationName));
    }

    @Override
    public @Nullable Object receiveSelectedAndConvert(@Nullable String messageSelector) throws JmsException {
        return this.doConvertFromMessage(this.receiveSelected(messageSelector));
    }

    @Override
    public @Nullable Object receiveSelectedAndConvert(Destination destination, @Nullable String messageSelector) throws JmsException {
        return this.doConvertFromMessage(this.receiveSelected(destination, messageSelector));
    }

    @Override
    public @Nullable Object receiveSelectedAndConvert(String destinationName, @Nullable String messageSelector) throws JmsException {
        return this.doConvertFromMessage(this.receiveSelected(destinationName, messageSelector));
    }

    protected @Nullable Object doConvertFromMessage(@Nullable Message message) {
        if (message != null) {
            try {
                return this.getMessageConverter().fromMessage(message);
            }
            catch (JMSException ex) {
                throw this.convertJmsAccessException(ex);
            }
        }
        return null;
    }

    @Override
    public @Nullable Message sendAndReceive(MessageCreator messageCreator) throws JmsException {
        Destination defaultDestination = this.getDefaultDestination();
        if (defaultDestination != null) {
            return this.sendAndReceive(defaultDestination, messageCreator);
        }
        return this.sendAndReceive(this.getRequiredDefaultDestinationName(), messageCreator);
    }

    @Override
    public @Nullable Message sendAndReceive(Destination destination, MessageCreator messageCreator) throws JmsException {
        return this.executeLocal(session -> this.doSendAndReceive(session, destination, messageCreator), true);
    }

    @Override
    public @Nullable Message sendAndReceive(String destinationName, MessageCreator messageCreator) throws JmsException {
        return this.executeLocal(session -> {
            Destination destination = this.resolveDestinationName(session, destinationName);
            return this.doSendAndReceive(session, destination, messageCreator);
        }, true);
    }

    @Override
    public @Nullable Message sendAndReceive(Destination destination, Destination responseQueue, MessageCreator messageCreator) throws JmsException {
        return this.executeLocal(session -> this.doSendAndReceive(session, destination, responseQueue, messageCreator, true), true);
    }

    @Override
    public @Nullable Message sendAndReceive(String destinationName, String responseQueueName, MessageCreator messageCreator) throws JmsException {
        return this.executeLocal(session -> {
            Destination destination = this.resolveDestinationName(session, destinationName);
            Destination responseQueue = this.resolveDestinationName(session, responseQueueName);
            return this.doSendAndReceive(session, destination, responseQueue, messageCreator, true);
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @Nullable Message doSendAndReceive(Session session, Destination destination, MessageCreator messageCreator) throws JMSException {
        TemporaryQueue responseQueue = null;
        try {
            responseQueue = session.createTemporaryQueue();
            Message message = this.doSendAndReceive(session, destination, (Destination)responseQueue, messageCreator, false);
            return message;
        }
        finally {
            if (responseQueue != null) {
                responseQueue.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @Nullable Message doSendAndReceive(Session session, Destination destination, Destination responseQueue, MessageCreator messageCreator, boolean useCorrelationId) throws JMSException {
        Message message;
        Assert.notNull((Object)messageCreator, (String)"MessageCreator must not be null");
        MessageProducer producer = null;
        MessageConsumer consumer = null;
        try {
            Message requestMessage = messageCreator.createMessage(session);
            producer = session.createProducer(destination);
            requestMessage.setJMSReplyTo(responseQueue);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Sending created message: " + String.valueOf(requestMessage)));
            }
            this.doSend(producer, requestMessage);
            String messageSelector = null;
            if (useCorrelationId) {
                String correlationId = requestMessage.getJMSCorrelationID();
                if (correlationId == null) {
                    correlationId = requestMessage.getJMSMessageID();
                }
                messageSelector = "JMSCorrelationID='" + correlationId + "'";
            }
            consumer = session.createConsumer(responseQueue, messageSelector);
            message = this.receiveFromConsumer(consumer, this.getReceiveTimeout());
        }
        catch (Throwable throwable) {
            JmsUtils.closeMessageConsumer(consumer);
            JmsUtils.closeMessageProducer(producer);
            throw throwable;
        }
        JmsUtils.closeMessageConsumer(consumer);
        JmsUtils.closeMessageProducer(producer);
        return message;
    }

    private <T> @Nullable T executeLocal(SessionCallback<T> action, boolean startConnection) throws JmsException {
        T t;
        Assert.notNull(action, (String)"Callback object must not be null");
        Connection con = null;
        Session session = null;
        try {
            con = this.createConnection();
            session = con.createSession(false, 1);
            if (MICROMETER_JAKARTA_PRESENT && this.observationRegistry != null) {
                session = MicrometerInstrumentation.instrumentSession(session, this.observationRegistry);
            }
            if (startConnection) {
                con.start();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executing callback on JMS Session: " + String.valueOf(session)));
            }
            t = action.doInJms(session);
        }
        catch (JMSException ex) {
            try {
                throw this.convertJmsAccessException(ex);
            }
            catch (Throwable throwable) {
                JmsUtils.closeSession(session);
                ConnectionFactoryUtils.releaseConnection(con, this.getConnectionFactory(), startConnection);
                throw throwable;
            }
        }
        JmsUtils.closeSession(session);
        ConnectionFactoryUtils.releaseConnection(con, this.getConnectionFactory(), startConnection);
        return t;
    }

    @Override
    public <T> @Nullable T browse(BrowserCallback<T> action) throws JmsException {
        Queue defaultQueue = this.getDefaultQueue();
        if (defaultQueue != null) {
            return this.browse(defaultQueue, action);
        }
        return this.browse(this.getRequiredDefaultDestinationName(), action);
    }

    @Override
    public <T> @Nullable T browse(Queue queue, BrowserCallback<T> action) throws JmsException {
        return this.browseSelected(queue, null, action);
    }

    @Override
    public <T> @Nullable T browse(String queueName, BrowserCallback<T> action) throws JmsException {
        return this.browseSelected(queueName, null, action);
    }

    @Override
    public <T> @Nullable T browseSelected(@Nullable String messageSelector, BrowserCallback<T> action) throws JmsException {
        Queue defaultQueue = this.getDefaultQueue();
        if (defaultQueue != null) {
            return this.browseSelected(defaultQueue, messageSelector, action);
        }
        return this.browseSelected(this.getRequiredDefaultDestinationName(), messageSelector, action);
    }

    @Override
    public <T> @Nullable T browseSelected(Queue queue, @Nullable String messageSelector, BrowserCallback<T> action) throws JmsException {
        Assert.notNull(action, (String)"Callback object must not be null");
        return (T)this.execute((Session session) -> {
            QueueBrowser browser = this.createBrowser(session, queue, messageSelector);
            try {
                Object t = action.doInJms(session, browser);
                return t;
            }
            finally {
                JmsUtils.closeQueueBrowser(browser);
            }
        }, true);
    }

    @Override
    public <T> @Nullable T browseSelected(String queueName, @Nullable String messageSelector, BrowserCallback<T> action) throws JmsException {
        Assert.notNull(action, (String)"Callback object must not be null");
        return (T)this.execute((Session session) -> {
            Queue queue = (Queue)this.getDestinationResolver().resolveDestinationName(session, queueName, false);
            QueueBrowser browser = this.createBrowser(session, queue, messageSelector);
            try {
                Object t = action.doInJms(session, browser);
                return t;
            }
            finally {
                JmsUtils.closeQueueBrowser(browser);
            }
        }, true);
    }

    protected @Nullable Connection getConnection(JmsResourceHolder holder) {
        return holder.getConnection();
    }

    protected @Nullable Session getSession(JmsResourceHolder holder) {
        return holder.getSession();
    }

    protected boolean isSessionLocallyTransacted(Session session) {
        return this.isSessionTransacted() && !ConnectionFactoryUtils.isSessionTransactional(session, this.getConnectionFactory());
    }

    protected MessageProducer createProducer(Session session, @Nullable Destination destination) throws JMSException {
        MessageProducer producer = this.doCreateProducer(session, destination);
        if (!this.isMessageIdEnabled()) {
            producer.setDisableMessageID(true);
        }
        if (!this.isMessageTimestampEnabled()) {
            producer.setDisableMessageTimestamp(true);
        }
        return producer;
    }

    protected MessageProducer doCreateProducer(Session session, @Nullable Destination destination) throws JMSException {
        return session.createProducer(destination);
    }

    protected MessageConsumer createConsumer(Session session, Destination destination, @Nullable String messageSelector) throws JMSException {
        if (this.isPubSubDomain()) {
            return session.createConsumer(destination, messageSelector, this.isPubSubNoLocal());
        }
        return session.createConsumer(destination, messageSelector);
    }

    protected QueueBrowser createBrowser(Session session, Queue queue, @Nullable String messageSelector) throws JMSException {
        return session.createBrowser(queue, messageSelector);
    }

    private class JmsTemplateResourceFactory
    implements ConnectionFactoryUtils.ResourceFactory {
        private JmsTemplateResourceFactory() {
        }

        @Override
        public @Nullable Connection getConnection(JmsResourceHolder holder) {
            return JmsTemplate.this.getConnection(holder);
        }

        @Override
        public @Nullable Session getSession(JmsResourceHolder holder) {
            return JmsTemplate.this.getSession(holder);
        }

        @Override
        public Connection createConnection() throws JMSException {
            return JmsTemplate.this.createConnection();
        }

        @Override
        public Session createSession(Connection con) throws JMSException {
            return JmsTemplate.this.createSession(con);
        }

        @Override
        public boolean isSynchedLocalTransactionAllowed() {
            return JmsTemplate.this.isSessionTransacted();
        }
    }

    private static abstract class MicrometerInstrumentation {
        private MicrometerInstrumentation() {
        }

        static Session instrumentSession(Session session, ObservationRegistry registry) {
            return JmsInstrumentation.instrumentSession((Session)session, (ObservationRegistry)registry);
        }
    }
}

