/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.asm.Label;
import org.springframework.asm.MethodVisitor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.BooleanTypedValue;

public class OpEQ
extends Operator {
    public OpEQ(int pos, SpelNodeImpl ... operands) {
        super("==", pos, operands);
        this.exitTypeDescriptor = "Z";
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        Object left = this.getLeftOperand().getValueInternal(state).getValue();
        Object right = this.getRightOperand().getValueInternal(state).getValue();
        this.leftActualDescriptor = CodeFlow.toDescriptorFromObject(left);
        this.rightActualDescriptor = CodeFlow.toDescriptorFromObject(right);
        return BooleanTypedValue.forValue(this.equalityCheck(state, left, right));
    }

    @Override
    public boolean isCompilable() {
        SpelNodeImpl left = this.getLeftOperand();
        SpelNodeImpl right = this.getRightOperand();
        if (!left.isCompilable() || !right.isCompilable()) {
            return false;
        }
        String leftDesc = left.exitTypeDescriptor;
        String rightDesc = right.exitTypeDescriptor;
        Operator.DescriptorComparison dc = Operator.DescriptorComparison.checkNumericCompatibility(leftDesc, rightDesc, this.leftActualDescriptor, this.rightActualDescriptor);
        return !dc.areNumbers || dc.areCompatible;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        String leftDesc = this.getLeftOperand().exitTypeDescriptor;
        String rightDesc = this.getRightOperand().exitTypeDescriptor;
        Label elseTarget = new Label();
        Label endOfIf = new Label();
        boolean leftPrim = CodeFlow.isPrimitive(leftDesc);
        boolean rightPrim = CodeFlow.isPrimitive(rightDesc);
        Operator.DescriptorComparison dc = Operator.DescriptorComparison.checkNumericCompatibility(leftDesc, rightDesc, this.leftActualDescriptor, this.rightActualDescriptor);
        if (dc.areNumbers && dc.areCompatible) {
            char targetType = dc.compatibleType;
            this.getLeftOperand().generateCode(mv, cf);
            if (!leftPrim) {
                CodeFlow.insertUnboxInsns(mv, targetType, leftDesc);
            }
            cf.enterCompilationScope();
            this.getRightOperand().generateCode(mv, cf);
            cf.exitCompilationScope();
            if (!rightPrim) {
                CodeFlow.insertUnboxInsns(mv, targetType, rightDesc);
            }
            if (targetType == 'D') {
                mv.visitInsn(151);
                mv.visitJumpInsn(154, elseTarget);
            } else if (targetType == 'F') {
                mv.visitInsn(149);
                mv.visitJumpInsn(154, elseTarget);
            } else if (targetType == 'J') {
                mv.visitInsn(148);
                mv.visitJumpInsn(154, elseTarget);
            } else {
                if (targetType != 'I' && targetType != 'Z') throw new IllegalStateException("Unexpected descriptor " + leftDesc);
                mv.visitJumpInsn(160, elseTarget);
            }
        } else {
            this.getLeftOperand().generateCode(mv, cf);
            this.getRightOperand().generateCode(mv, cf);
            Label leftNotNull = new Label();
            mv.visitInsn(90);
            mv.visitJumpInsn(199, leftNotNull);
            mv.visitInsn(95);
            mv.visitInsn(87);
            Label rightNotNull = new Label();
            mv.visitJumpInsn(199, rightNotNull);
            mv.visitInsn(4);
            mv.visitJumpInsn(167, endOfIf);
            mv.visitLabel(rightNotNull);
            mv.visitInsn(3);
            mv.visitJumpInsn(167, endOfIf);
            mv.visitLabel(leftNotNull);
            mv.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z", false);
            mv.visitLabel(endOfIf);
            cf.pushDescriptor("Z");
            return;
        }
        mv.visitInsn(4);
        mv.visitJumpInsn(167, endOfIf);
        mv.visitLabel(elseTarget);
        mv.visitInsn(3);
        mv.visitLabel(endOfIf);
        cf.pushDescriptor("Z");
    }
}

