/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.validation.annotation.Validated;

public abstract class ValidationAnnotationUtils {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

    public static Object @Nullable [] determineValidationHints(Annotation ann) {
        if (ann instanceof Validated) {
            Validated validated = (Validated)ann;
            return validated.value();
        }
        Class<? extends Annotation> annotationType = ann.annotationType();
        if ("jakarta.validation.Valid".equals(annotationType.getName())) {
            return EMPTY_OBJECT_ARRAY;
        }
        Validated validatedAnn = (Validated)AnnotationUtils.findAnnotation(annotationType, Validated.class);
        if (validatedAnn != null) {
            return validatedAnn.value();
        }
        if (annotationType.getSimpleName().startsWith("Valid")) {
            return ValidationAnnotationUtils.convertValidationHints(AnnotationUtils.getValue((Annotation)ann));
        }
        return null;
    }

    private static Object[] convertValidationHints(@Nullable Object hints) {
        Object[] objectArray;
        if (hints == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        if (hints instanceof Object[]) {
            Object[] objectHints = (Object[])hints;
            objectArray = objectHints;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = hints;
        }
        return objectArray;
    }

    public static Class<?>[] determineValidationGroups(Object target, Method method) {
        Validated validatedAnn = (Validated)AnnotationUtils.findAnnotation((Method)method, Validated.class);
        if (validatedAnn == null) {
            if (AopUtils.isAopProxy((Object)target)) {
                Class type;
                Class[] classArray = AopProxyUtils.proxiedUserInterfaces((Object)target);
                int n = classArray.length;
                for (int i = 0; i < n && (validatedAnn = (Validated)AnnotationUtils.findAnnotation((Class)(type = classArray[i]), Validated.class)) == null; ++i) {
                }
            } else {
                validatedAnn = (Validated)AnnotationUtils.findAnnotation(target.getClass(), Validated.class);
            }
        }
        return validatedAnn != null ? validatedAnn.value() : EMPTY_CLASS_ARRAY;
    }
}

