/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConfigurationBeanNameGenerator;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.ConcurrentReferenceHashMap;

abstract class BeanAnnotationHelper {
    private static final Map<Method, String> beanNameCache = new ConcurrentReferenceHashMap();
    private static final Map<Method, Boolean> scopedProxyCache = new ConcurrentReferenceHashMap();

    BeanAnnotationHelper() {
    }

    public static boolean isBeanAnnotated(Method method) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, Bean.class);
    }

    public static String determineBeanNameFor(Method beanMethod, ConfigurableBeanFactory beanFactory) {
        String beanName = BeanAnnotationHelper.retrieveBeanNameFor(beanMethod);
        Object object = beanFactory.getSingleton("org.springframework.context.annotation.internalConfigurationBeanNameGenerator");
        if (object instanceof ConfigurationBeanNameGenerator) {
            ConfigurationBeanNameGenerator cbng = (ConfigurationBeanNameGenerator)object;
            return cbng.deriveBeanName(MethodMetadata.introspect((Method)beanMethod), !beanName.isEmpty() ? beanName : null);
        }
        return BeanAnnotationHelper.determineBeanNameFrom(beanName, beanMethod);
    }

    public static String determineBeanNameFor(Method beanMethod) {
        return BeanAnnotationHelper.determineBeanNameFrom(BeanAnnotationHelper.retrieveBeanNameFor(beanMethod), beanMethod);
    }

    private static String retrieveBeanNameFor(Method beanMethod) {
        String beanName = beanNameCache.get(beanMethod);
        if (beanName == null) {
            String[] names;
            beanName = "";
            AnnotationAttributes bean2 = AnnotatedElementUtils.findMergedAnnotationAttributes((AnnotatedElement)beanMethod, Bean.class, (boolean)false, (boolean)false);
            if (bean2 != null && (names = bean2.getStringArray("name")).length > 0) {
                beanName = names[0];
            }
            beanNameCache.put(beanMethod, beanName);
        }
        return beanName;
    }

    private static String determineBeanNameFrom(String derivedBeanName, Method beanMethod) {
        return !derivedBeanName.isEmpty() ? derivedBeanName : beanMethod.getName();
    }

    public static boolean isScopedProxy(Method beanMethod) {
        Boolean scopedProxy = scopedProxyCache.get(beanMethod);
        if (scopedProxy == null) {
            AnnotationAttributes scope = AnnotatedElementUtils.findMergedAnnotationAttributes((AnnotatedElement)beanMethod, Scope.class, (boolean)false, (boolean)false);
            scopedProxy = scope != null && scope.getEnum("proxyMode") != ScopedProxyMode.NO;
            scopedProxyCache.put(beanMethod, scopedProxy);
        }
        return scopedProxy;
    }

    static void clearCaches() {
        scopedProxyCache.clear();
        beanNameCache.clear();
    }
}

