/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import java.util.Properties;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PlaceholderConfigurerSupport;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.ConfigurablePropertyResolver;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringValueResolver;

public class PropertySourcesPlaceholderConfigurer
extends PlaceholderConfigurerSupport
implements EnvironmentAware {
    public static final String LOCAL_PROPERTIES_PROPERTY_SOURCE_NAME = "localProperties";
    public static final String ENVIRONMENT_PROPERTIES_PROPERTY_SOURCE_NAME = "environmentProperties";
    private @Nullable MutablePropertySources propertySources;
    private @Nullable PropertySources appliedPropertySources;
    private @Nullable Environment environment;

    public void setPropertySources(PropertySources propertySources) {
        this.propertySources = new MutablePropertySources(propertySources);
    }

    @Override
    public void setEnvironment(Environment environment2) {
        this.environment = environment2;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.propertySources == null) {
            this.propertySources = new MutablePropertySources();
            if (this.environment != null) {
                Environment environment2;
                Environment propertyResolver = this.environment;
                if (this.ignoreUnresolvablePlaceholders && (environment2 = this.environment) instanceof ConfigurableEnvironment) {
                    ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)environment2;
                    PropertySourcesPropertyResolver resolver = new PropertySourcesPropertyResolver((PropertySources)configurableEnvironment.getPropertySources());
                    resolver.setIgnoreUnresolvableNestedPlaceholders(true);
                    propertyResolver = resolver;
                }
                Environment propertyResolverToUse = propertyResolver;
                this.propertySources.addLast((PropertySource)new PropertySource<Environment>(this, ENVIRONMENT_PROPERTIES_PROPERTY_SOURCE_NAME, this.environment, (PropertyResolver)propertyResolverToUse){
                    final /* synthetic */ PropertyResolver val$propertyResolverToUse;
                    final /* synthetic */ PropertySourcesPlaceholderConfigurer this$0;
                    {
                        this.val$propertyResolverToUse = propertyResolver;
                        this.this$0 = this$0;
                        super(name, (Object)source);
                    }

                    public @Nullable String getProperty(String key) {
                        return this.val$propertyResolverToUse.getProperty(key);
                    }
                });
            }
            try {
                PropertiesPropertySource localPropertySource = new PropertiesPropertySource(LOCAL_PROPERTIES_PROPERTY_SOURCE_NAME, this.mergeProperties());
                if (this.localOverride) {
                    this.propertySources.addFirst((PropertySource)localPropertySource);
                } else {
                    this.propertySources.addLast((PropertySource)localPropertySource);
                }
            }
            catch (IOException ex) {
                throw new BeanInitializationException("Could not load properties", (Throwable)ex);
            }
        }
        this.processProperties(beanFactory, this.createPropertyResolver(this.propertySources));
        this.appliedPropertySources = this.propertySources;
    }

    protected ConfigurablePropertyResolver createPropertyResolver(MutablePropertySources propertySources) {
        return new PropertySourcesPropertyResolver((PropertySources)propertySources);
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, ConfigurablePropertyResolver propertyResolver) throws BeansException {
        propertyResolver.setPlaceholderPrefix(this.placeholderPrefix);
        propertyResolver.setPlaceholderSuffix(this.placeholderSuffix);
        propertyResolver.setValueSeparator(this.valueSeparator);
        propertyResolver.setEscapeCharacter(this.escapeCharacter);
        StringValueResolver valueResolver = strVal -> {
            String resolved;
            String string = resolved = this.ignoreUnresolvablePlaceholders ? propertyResolver.resolvePlaceholders(strVal) : propertyResolver.resolveRequiredPlaceholders(strVal);
            if (this.trimValues) {
                resolved = resolved.trim();
            }
            return resolved.equals(this.nullValue) ? null : resolved;
        };
        this.doProcessProperties(beanFactoryToProcess, valueResolver);
    }

    @Deprecated
    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) {
        throw new UnsupportedOperationException("Call processProperties(ConfigurableListableBeanFactory, ConfigurablePropertyResolver) instead");
    }

    public PropertySources getAppliedPropertySources() throws IllegalStateException {
        Assert.state((this.appliedPropertySources != null ? 1 : 0) != 0, (String)"PropertySources have not yet been applied");
        return this.appliedPropertySources;
    }
}

