/*
 * Copyright 2004-2007 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.binding.convert;

/**
 * A context object with two main responsibities:
 * <ol>
 * <li>Exposing information to a converter to influence a type conversion attempt.
 * <li>Providing operations for recording progress or errors during the type conversion process.
 * </ol>
 * Empty for now; subclasses may define their own custom context behavior accessible by a converter with a downcast.
 * 
 * @author Keith Donald
 */
public interface ConversionContext {

}
