/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeMap;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

abstract class PropertyDescriptorUtils {
    public static final PropertyDescriptor[] EMPTY_PROPERTY_DESCRIPTOR_ARRAY = new PropertyDescriptor[0];

    PropertyDescriptorUtils() {
    }

    public static Collection<? extends PropertyDescriptor> determineBasicProperties(Class<?> beanClass) throws IntrospectionException {
        TreeMap<String, BasicPropertyDescriptor> pdMap = new TreeMap<String, BasicPropertyDescriptor>();
        for (Method method : beanClass.getMethods()) {
            int nameIndex;
            boolean setter;
            String methodName = method.getName();
            if (methodName.startsWith("set") && method.getParameterCount() == 1) {
                setter = true;
                nameIndex = 3;
            } else if (methodName.startsWith("get") && method.getParameterCount() == 0 && method.getReturnType() != Void.TYPE) {
                setter = false;
                nameIndex = 3;
            } else {
                if (!methodName.startsWith("is") || method.getParameterCount() != 0 || method.getReturnType() != Boolean.TYPE) continue;
                setter = false;
                nameIndex = 2;
            }
            String propertyName = StringUtils.uncapitalizeAsProperty((String)methodName.substring(nameIndex));
            if (propertyName.isEmpty()) continue;
            BasicPropertyDescriptor pd = (BasicPropertyDescriptor)pdMap.get(propertyName);
            if (pd != null) {
                if (setter) {
                    pd.addWriteMethod(method);
                    continue;
                }
                Method readMethod = pd.getReadMethod();
                if (readMethod != null && !readMethod.getReturnType().isAssignableFrom(method.getReturnType())) continue;
                pd.setReadMethod(method);
                continue;
            }
            pd = new BasicPropertyDescriptor(propertyName, beanClass, !setter ? method : null, setter ? method : null);
            pdMap.put(propertyName, pd);
        }
        return pdMap.values();
    }

    public static void copyNonMethodProperties(PropertyDescriptor source, PropertyDescriptor target) {
        target.setExpert(source.isExpert());
        target.setHidden(source.isHidden());
        target.setPreferred(source.isPreferred());
        target.setName(source.getName());
        target.setShortDescription(source.getShortDescription());
        target.setDisplayName(source.getDisplayName());
        Enumeration<String> keys = source.attributeNames();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            target.setValue(key, source.getValue(key));
        }
        target.setPropertyEditorClass(source.getPropertyEditorClass());
        target.setBound(source.isBound());
        target.setConstrained(source.isConstrained());
    }

    public static @Nullable Class<?> findPropertyType(@Nullable Method readMethod, @Nullable Method writeMethod) throws IntrospectionException {
        Class<?> propertyType = null;
        if (readMethod != null) {
            if (readMethod.getParameterCount() != 0) {
                throw new IntrospectionException("Bad read method arg count: " + String.valueOf(readMethod));
            }
            propertyType = readMethod.getReturnType();
            if (propertyType == Void.TYPE) {
                throw new IntrospectionException("Read method returns void: " + String.valueOf(readMethod));
            }
        }
        if (writeMethod != null) {
            Class<?>[] params = writeMethod.getParameterTypes();
            if (params.length != 1) {
                throw new IntrospectionException("Bad write method arg count: " + String.valueOf(writeMethod));
            }
            if (propertyType != null) {
                if (propertyType.isAssignableFrom(params[0])) {
                    propertyType = params[0];
                } else if (!params[0].isAssignableFrom(propertyType)) {
                    throw new IntrospectionException("Type mismatch between read and write methods: " + String.valueOf(readMethod) + " - " + String.valueOf(writeMethod));
                }
            } else {
                propertyType = params[0];
            }
        }
        return propertyType;
    }

    public static @Nullable Class<?> findIndexedPropertyType(String name, @Nullable Class<?> propertyType, @Nullable Method indexedReadMethod, @Nullable Method indexedWriteMethod) throws IntrospectionException {
        Class<?>[] params;
        Class<?> indexedPropertyType = null;
        if (indexedReadMethod != null) {
            params = indexedReadMethod.getParameterTypes();
            if (params.length != 1) {
                throw new IntrospectionException("Bad indexed read method arg count: " + String.valueOf(indexedReadMethod));
            }
            if (params[0] != Integer.TYPE) {
                throw new IntrospectionException("Non int index to indexed read method: " + String.valueOf(indexedReadMethod));
            }
            indexedPropertyType = indexedReadMethod.getReturnType();
            if (indexedPropertyType == Void.TYPE) {
                throw new IntrospectionException("Indexed read method returns void: " + String.valueOf(indexedReadMethod));
            }
        }
        if (indexedWriteMethod != null) {
            params = indexedWriteMethod.getParameterTypes();
            if (params.length != 2) {
                throw new IntrospectionException("Bad indexed write method arg count: " + String.valueOf(indexedWriteMethod));
            }
            if (params[0] != Integer.TYPE) {
                throw new IntrospectionException("Non int index to indexed write method: " + String.valueOf(indexedWriteMethod));
            }
            if (indexedPropertyType != null) {
                if (indexedPropertyType.isAssignableFrom(params[1])) {
                    indexedPropertyType = params[1];
                } else if (!params[1].isAssignableFrom(indexedPropertyType)) {
                    throw new IntrospectionException("Type mismatch between indexed read and write methods: " + String.valueOf(indexedReadMethod) + " - " + String.valueOf(indexedWriteMethod));
                }
            } else {
                indexedPropertyType = params[1];
            }
        }
        if (!(propertyType == null || propertyType.isArray() && propertyType.componentType() == indexedPropertyType)) {
            throw new IntrospectionException("Type mismatch between indexed and non-indexed methods: " + String.valueOf(indexedReadMethod) + " - " + String.valueOf(indexedWriteMethod));
        }
        return indexedPropertyType;
    }

    public static boolean equals(PropertyDescriptor pd, PropertyDescriptor otherPd) {
        return ObjectUtils.nullSafeEquals((Object)pd.getReadMethod(), (Object)otherPd.getReadMethod()) && ObjectUtils.nullSafeEquals((Object)pd.getWriteMethod(), (Object)otherPd.getWriteMethod()) && ObjectUtils.nullSafeEquals(pd.getPropertyType(), otherPd.getPropertyType()) && ObjectUtils.nullSafeEquals(pd.getPropertyEditorClass(), otherPd.getPropertyEditorClass()) && pd.isBound() == otherPd.isBound() && pd.isConstrained() == otherPd.isConstrained();
    }

    private static class BasicPropertyDescriptor
    extends PropertyDescriptor {
        private final Class<?> beanClass;
        private @Nullable Method readMethod;
        private @Nullable Method writeMethod;
        private final List<Method> candidateWriteMethods = new ArrayList<Method>();

        public BasicPropertyDescriptor(String propertyName, Class<?> beanClass, @Nullable Method readMethod, @Nullable Method writeMethod) throws IntrospectionException {
            super(propertyName, readMethod, writeMethod);
            this.beanClass = beanClass;
        }

        @Override
        public void setReadMethod(@Nullable Method readMethod) {
            this.readMethod = readMethod;
        }

        @Override
        public @Nullable Method getReadMethod() {
            return this.readMethod;
        }

        @Override
        public void setWriteMethod(@Nullable Method writeMethod) {
            this.writeMethod = writeMethod;
        }

        void addWriteMethod(Method writeMethod) {
            if (this.writeMethod != null) {
                this.candidateWriteMethods.add(this.writeMethod);
                this.writeMethod = null;
            }
            this.candidateWriteMethods.add(writeMethod);
        }

        @Override
        public @Nullable Method getWriteMethod() {
            if (this.writeMethod == null && !this.candidateWriteMethods.isEmpty()) {
                if (this.readMethod == null || this.candidateWriteMethods.size() == 1) {
                    this.writeMethod = this.candidateWriteMethods.get(0);
                } else {
                    Class resolvedReadType = ResolvableType.forMethodReturnType((Method)this.readMethod, this.beanClass).toClass();
                    for (Method method : this.candidateWriteMethods) {
                        Class resolvedWriteType = ResolvableType.forMethodParameter((Method)method, (int)0, this.beanClass).toClass();
                        if (resolvedReadType.equals(resolvedWriteType)) {
                            this.writeMethod = method;
                            break;
                        }
                        Class<?> parameterType = method.getParameterTypes()[0];
                        if (!this.readMethod.getReturnType().isAssignableFrom(parameterType) || this.writeMethod != null && !this.writeMethod.getParameterTypes()[0].isAssignableFrom(parameterType)) continue;
                        this.writeMethod = method;
                    }
                }
            }
            return this.writeMethod;
        }
    }
}

