/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public abstract class AbstractBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String ID_ATTRIBUTE = "id";

    public final BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinition definition = this.parseInternal(element, parserContext);
        String id = this.resolveId(definition, parserContext, element);
        if (StringUtils.hasText((String)id)) {
            BeanDefinitionHolder holder = new BeanDefinitionHolder(definition, id);
            BeanDefinitionReaderUtils.registerBeanDefinition(holder, parserContext.getRegistry());
            if (this.shouldFireEvents()) {
                BeanComponentDefinition componentDefinition = new BeanComponentDefinition(holder);
                this.postProcessComponentDefinition(componentDefinition);
                parserContext.getReaderContext().fireComponentRegistered(componentDefinition);
            }
        } else if (!parserContext.isNested()) {
            throw new IllegalArgumentException("Attribute 'id' is required for element '" + element.getLocalName() + "' when used as a top-level tag.");
        }
        return definition;
    }

    private String resolveId(BeanDefinition definition, ParserContext parserContext, Element element) {
        if (this.autogenerateId()) {
            return BeanDefinitionReaderUtils.generateBeanName((AbstractBeanDefinition)definition, parserContext.getRegistry(), parserContext.isNested());
        }
        return this.extractId(element);
    }

    protected abstract BeanDefinition parseInternal(Element var1, ParserContext var2);

    protected void postProcessComponentDefinition(BeanComponentDefinition componentDefinition) {
    }

    protected String extractId(Element element) {
        return element.getAttribute(ID_ATTRIBUTE);
    }

    protected boolean shouldFireEvents() {
        return true;
    }

    protected boolean autogenerateId() {
        return false;
    }
}

