/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class BeanFactoryUtils {
    public static boolean isFactoryDereference(String name) {
        return name.startsWith("&");
    }

    public static String transformedBeanName(String name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        String beanName = name;
        if (beanName.startsWith("&")) {
            beanName = beanName.substring("&".length());
        }
        return beanName;
    }

    public static int countBeansIncludingAncestors(ListableBeanFactory lbf) {
        return BeanFactoryUtils.beanNamesIncludingAncestors(lbf).length;
    }

    public static String[] beanNamesIncludingAncestors(ListableBeanFactory lbf) {
        HierarchicalBeanFactory hbf;
        Assert.notNull((Object)lbf, (String)"ListableBeanFactory must not be null");
        HashSet<String> result = new HashSet<String>();
        result.addAll(Arrays.asList(lbf.getBeanDefinitionNames()));
        if (lbf instanceof HierarchicalBeanFactory && (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory() instanceof ListableBeanFactory) {
            String[] parentResult = BeanFactoryUtils.beanNamesIncludingAncestors((ListableBeanFactory)hbf.getParentBeanFactory());
            result.addAll(Arrays.asList(parentResult));
        }
        return StringUtils.toStringArray(result);
    }

    public static String[] beanNamesForTypeIncludingAncestors(ListableBeanFactory lbf, Class type) {
        HierarchicalBeanFactory hbf;
        Assert.notNull((Object)lbf, (String)"ListableBeanFactory must not be null");
        HashSet<String> result = new HashSet<String>();
        result.addAll(Arrays.asList(lbf.getBeanNamesForType(type)));
        if (lbf instanceof HierarchicalBeanFactory && (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory() instanceof ListableBeanFactory) {
            String[] parentResult = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)hbf.getParentBeanFactory(), type);
            result.addAll(Arrays.asList(parentResult));
        }
        return StringUtils.toStringArray(result);
    }

    public static String[] beanNamesForTypeIncludingAncestors(ListableBeanFactory lbf, Class type, boolean includePrototypes, boolean allowEagerInit) {
        HierarchicalBeanFactory hbf;
        Assert.notNull((Object)lbf, (String)"ListableBeanFactory must not be null");
        HashSet<String> result = new HashSet<String>();
        result.addAll(Arrays.asList(lbf.getBeanNamesForType(type, includePrototypes, allowEagerInit)));
        if (lbf instanceof HierarchicalBeanFactory && (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory() instanceof ListableBeanFactory) {
            String[] parentResult = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)hbf.getParentBeanFactory(), type, includePrototypes, allowEagerInit);
            result.addAll(Arrays.asList(parentResult));
        }
        return StringUtils.toStringArray(result);
    }

    public static Map beansOfTypeIncludingAncestors(ListableBeanFactory lbf, Class type) throws BeansException {
        HierarchicalBeanFactory hbf;
        Assert.notNull((Object)lbf, (String)"ListableBeanFactory must not be null");
        HashMap result = new HashMap();
        result.putAll(lbf.getBeansOfType(type));
        if (lbf instanceof HierarchicalBeanFactory && (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory() instanceof ListableBeanFactory) {
            Map parentResult = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)hbf.getParentBeanFactory(), type);
            Iterator it = parentResult.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (result.containsKey(entry.getKey())) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public static Map beansOfTypeIncludingAncestors(ListableBeanFactory lbf, Class type, boolean includePrototypes, boolean allowEagerInit) throws BeansException {
        HierarchicalBeanFactory hbf;
        Assert.notNull((Object)lbf, (String)"ListableBeanFactory must not be null");
        HashMap result = new HashMap();
        result.putAll(lbf.getBeansOfType(type, includePrototypes, allowEagerInit));
        if (lbf instanceof HierarchicalBeanFactory && (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory() instanceof ListableBeanFactory) {
            Map parentResult = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)hbf.getParentBeanFactory(), type, includePrototypes, allowEagerInit);
            Iterator it = parentResult.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (result.containsKey(entry.getKey())) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public static Object beanOfTypeIncludingAncestors(ListableBeanFactory lbf, Class type) throws BeansException {
        Map beansOfType = BeanFactoryUtils.beansOfTypeIncludingAncestors(lbf, type);
        if (beansOfType.size() == 1) {
            return beansOfType.values().iterator().next();
        }
        throw new NoSuchBeanDefinitionException(type, "expected single bean but found " + beansOfType.size());
    }

    public static Object beanOfTypeIncludingAncestors(ListableBeanFactory lbf, Class type, boolean includePrototypes, boolean allowEagerInit) throws BeansException {
        Map beansOfType = BeanFactoryUtils.beansOfTypeIncludingAncestors(lbf, type, includePrototypes, allowEagerInit);
        if (beansOfType.size() == 1) {
            return beansOfType.values().iterator().next();
        }
        throw new NoSuchBeanDefinitionException(type, "expected single bean but found " + beansOfType.size());
    }

    public static Object beanOfType(ListableBeanFactory lbf, Class type) throws BeansException {
        Assert.notNull((Object)lbf, (String)"ListableBeanFactory must not be null");
        Map beansOfType = lbf.getBeansOfType(type);
        if (beansOfType.size() == 1) {
            return beansOfType.values().iterator().next();
        }
        throw new NoSuchBeanDefinitionException(type, "expected single bean but found " + beansOfType.size());
    }

    public static Object beanOfType(ListableBeanFactory lbf, Class type, boolean includePrototypes, boolean allowEagerInit) throws BeansException {
        Assert.notNull((Object)lbf, (String)"ListableBeanFactory must not be null");
        Map beansOfType = lbf.getBeansOfType(type, includePrototypes, allowEagerInit);
        if (beansOfType.size() == 1) {
            return beansOfType.values().iterator().next();
        }
        throw new NoSuchBeanDefinitionException(type, "expected single bean but found " + beansOfType.size());
    }
}

