/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.web.thymeleaf;

import org.springframework.context.ApplicationContext;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.util.ClassUtils;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.processor.attr.AbstractConditionalVisibilityAttrProcessor;
import org.thymeleaf.spring3.context.SpringWebContext;

class ConnectedAttrProcessor
extends AbstractConditionalVisibilityAttrProcessor {
    private final boolean thymeleaf3Present = ClassUtils.isPresent((String)"org.thymeleaf.spring3.context.SpringWebContext", (ClassLoader)ConnectedAttrProcessor.class.getClassLoader());
    private final boolean thymeleaf4Present = ClassUtils.isPresent((String)"org.thymeleaf.spring4.context.SpringWebContext", (ClassLoader)ConnectedAttrProcessor.class.getClassLoader());

    public ConnectedAttrProcessor() {
        super("connected");
    }

    public int getPrecedence() {
        return 300;
    }

    protected boolean isVisible(Arguments arguments, Element element, String attributeName) {
        String providerId = element.getAttributeValue(attributeName);
        if (providerId == null || providerId.trim().equals("")) {
            return false;
        }
        ConnectionRepository connectionRepository = this.getConnectionRepository(arguments.getContext());
        return connectionRepository.findConnections(providerId).size() > 0;
    }

    private ConnectionRepository getConnectionRepository(IContext context) {
        ApplicationContext applicationContext = null;
        if (this.thymeleaf4Present) {
            applicationContext = this.getSpringApplicationContextForThymeleaf4(context);
        } else if (this.thymeleaf3Present) {
            applicationContext = this.getSpringApplicationContextForThymeleaf3(context);
        } else {
            throw new ConfigurationException("Neither Thymeleaf 3 SpringWebContext nor Thymeleaf 4 SpringWebContext is in the application classpath.");
        }
        ConnectionRepository connectionRepository = (ConnectionRepository)applicationContext.getBean(ConnectionRepository.class);
        return connectionRepository;
    }

    private ApplicationContext getSpringApplicationContextForThymeleaf3(IContext context) {
        if (!(context instanceof SpringWebContext)) {
            throw new ConfigurationException("Thymeleaf execution context is not a Spring web context (implementation of " + SpringWebContext.class.getName() + ". Spring Social integration can only be used in " + "web environements with a Spring application context.");
        }
        SpringWebContext springContext = (SpringWebContext)context;
        return springContext.getApplicationContext();
    }

    private ApplicationContext getSpringApplicationContextForThymeleaf4(IContext context) {
        if (!(context instanceof org.thymeleaf.spring4.context.SpringWebContext)) {
            throw new ConfigurationException("Thymeleaf execution context is not a Spring web context (implementation of " + org.thymeleaf.spring4.context.SpringWebContext.class.getName() + ". Spring Social integration can only be used in " + "web environements with a Spring application context.");
        }
        org.thymeleaf.spring4.context.SpringWebContext springContext = (org.thymeleaf.spring4.context.SpringWebContext)context;
        return springContext.getApplicationContext();
    }
}

