/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.web;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.social.facebook.web.FacebookCookieParser;
import org.springframework.social.facebook.web.FacebookCookieValue;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.context.request.NativeWebRequest;

public class FacebookWebArgumentResolver
implements WebArgumentResolver {
    private final String appId;
    private final String appSecret;

    public FacebookWebArgumentResolver(String appId, String appSecret) {
        this.appId = appId;
        this.appSecret = appSecret;
    }

    public Object resolveArgument(MethodParameter parameter, NativeWebRequest request) throws Exception {
        String key;
        FacebookCookieValue annotation = (FacebookCookieValue)parameter.getParameterAnnotation(FacebookCookieValue.class);
        if (annotation == null) {
            return WebArgumentResolver.UNRESOLVED;
        }
        HttpServletRequest nativeRequest = (HttpServletRequest)request.getNativeRequest();
        Map<String, String> cookieData = FacebookCookieParser.getFacebookCookieData(nativeRequest.getCookies(), this.appId, this.appSecret);
        if (!cookieData.containsKey(key = annotation.value()) && annotation.required()) {
            throw new IllegalStateException("Missing required Facebook cookie value '" + key + "'");
        }
        return cookieData.get(key);
    }
}

