/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.mongo;

import java.time.Duration;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.data.mongo.AbstractMongoSessionConverter;
import org.springframework.session.data.mongo.JdkMongoSessionConverter;
import org.springframework.session.data.mongo.MongoSession;
import org.springframework.session.data.mongo.MongoSessionUtils;
import org.springframework.session.events.SessionCreatedEvent;
import org.springframework.session.events.SessionDeletedEvent;
import reactor.core.publisher.Mono;

public class ReactiveMongoOperationsSessionRepository
implements ReactiveSessionRepository<MongoSession>,
ApplicationEventPublisherAware,
InitializingBean {
    public static final int DEFAULT_INACTIVE_INTERVAL = 1800;
    public static final String DEFAULT_COLLECTION_NAME = "sessions";
    private static final Logger logger = LoggerFactory.getLogger(ReactiveMongoOperationsSessionRepository.class);
    private final ReactiveMongoOperations mongoOperations;
    private Integer maxInactiveIntervalInSeconds = 1800;
    private String collectionName = "sessions";
    private AbstractMongoSessionConverter mongoSessionConverter = new JdkMongoSessionConverter(Duration.ofSeconds(this.maxInactiveIntervalInSeconds.intValue()));
    private MongoOperations blockingMongoOperations;
    private ApplicationEventPublisher eventPublisher;

    public ReactiveMongoOperationsSessionRepository(ReactiveMongoOperations mongoOperations) {
        this.mongoOperations = mongoOperations;
    }

    public Mono<MongoSession> createSession() {
        return Mono.justOrEmpty((Object)this.maxInactiveIntervalInSeconds).map(MongoSession::new).map(mongoSession -> {
            this.publishEvent((ApplicationEvent)new SessionCreatedEvent((Object)this, (Session)mongoSession));
            return mongoSession;
        }).switchIfEmpty(Mono.just((Object)new MongoSession()));
    }

    public Mono<Void> save(MongoSession session) {
        return this.mongoOperations.save((Object)MongoSessionUtils.convertToDBObject(this.mongoSessionConverter, session), this.collectionName).then();
    }

    public Mono<MongoSession> findById(String id) {
        return this.findSession(id).map(document -> MongoSessionUtils.convertToSession(this.mongoSessionConverter, document)).filter(mongoSession -> !mongoSession.isExpired()).switchIfEmpty(Mono.defer(() -> this.deleteById(id).then(Mono.empty())));
    }

    public Mono<Void> deleteById(String id) {
        return this.findSession(id).flatMap(document -> this.mongoOperations.remove(document, this.collectionName).then(Mono.just((Object)document))).map(document -> MongoSessionUtils.convertToSession(this.mongoSessionConverter, document)).map(mongoSession -> Mono.fromRunnable(() -> this.publishEvent((ApplicationEvent)new SessionDeletedEvent((Object)this, (Session)mongoSession)))).then();
    }

    public void afterPropertiesSet() {
        if (this.blockingMongoOperations != null) {
            IndexOperations indexOperations = this.blockingMongoOperations.indexOps(this.collectionName);
            this.mongoSessionConverter.ensureIndexes(indexOperations);
        }
    }

    private Mono<Document> findSession(String id) {
        return this.mongoOperations.findById((Object)id, Document.class, this.collectionName);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    private void publishEvent(ApplicationEvent event) {
        try {
            this.eventPublisher.publishEvent(event);
        }
        catch (Throwable ex) {
            logger.error("Error publishing " + event + ".", ex);
        }
    }

    public Integer getMaxInactiveIntervalInSeconds() {
        return this.maxInactiveIntervalInSeconds;
    }

    public void setMaxInactiveIntervalInSeconds(Integer maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setMongoSessionConverter(AbstractMongoSessionConverter mongoSessionConverter) {
        this.mongoSessionConverter = mongoSessionConverter;
    }

    public void setBlockingMongoOperations(MongoOperations blockingMongoOperations) {
        this.blockingMongoOperations = blockingMongoOperations;
    }
}

