/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bson.Document;
import org.bson.types.Binary;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.data.mongo.AbstractMongoSessionConverter;
import org.springframework.session.data.mongo.MongoSession;
import org.springframework.util.Assert;

public class JdkMongoSessionConverter
extends AbstractMongoSessionConverter {
    private static final String ID = "_id";
    private static final String CREATION_TIME = "created";
    private static final String LAST_ACCESSED_TIME = "accessed";
    private static final String MAX_INTERVAL = "interval";
    private static final String ATTRIBUTES = "attr";
    private static final String PRINCIPAL_FIELD_NAME = "principal";
    private final Converter<Object, byte[]> serializer;
    private final Converter<byte[], Object> deserializer;
    private Duration maxInactiveInterval;

    public JdkMongoSessionConverter(Duration maxInactiveInterval) {
        this((Converter<Object, byte[]>)new SerializingConverter(), (Converter<byte[], Object>)new DeserializingConverter(), maxInactiveInterval);
    }

    public JdkMongoSessionConverter(Converter<Object, byte[]> serializer, Converter<byte[], Object> deserializer, Duration maxInactiveInterval) {
        Assert.notNull(serializer, (String)"serializer cannot be null");
        Assert.notNull(deserializer, (String)"deserializer cannot be null");
        Assert.notNull((Object)maxInactiveInterval, (String)"maxInactiveInterval cannot be null");
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.maxInactiveInterval = maxInactiveInterval;
    }

    @Override
    public Query getQueryForIndex(String indexName, Object indexValue) {
        if (FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME.equals(indexName)) {
            return Query.query((CriteriaDefinition)Criteria.where((String)PRINCIPAL_FIELD_NAME).is(indexValue));
        }
        return null;
    }

    @Override
    protected DBObject convert(MongoSession session) {
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)ID, (Object)session.getId());
        basicDBObject.put((Object)CREATION_TIME, (Object)session.getCreationTime());
        basicDBObject.put((Object)LAST_ACCESSED_TIME, (Object)session.getLastAccessedTime());
        basicDBObject.put((Object)MAX_INTERVAL, (Object)session.getMaxInactiveInterval());
        basicDBObject.put((Object)PRINCIPAL_FIELD_NAME, (Object)this.extractPrincipal(session));
        basicDBObject.put((Object)"expireAt", (Object)session.getExpireAt());
        basicDBObject.put((Object)ATTRIBUTES, (Object)this.serializeAttributes(session));
        return basicDBObject;
    }

    @Override
    protected MongoSession convert(Document sessionWrapper) {
        Object maxInterval = sessionWrapper.getOrDefault((Object)MAX_INTERVAL, (Object)this.maxInactiveInterval);
        Duration maxIntervalDuration = maxInterval instanceof Duration ? (Duration)maxInterval : Duration.parse(maxInterval.toString());
        MongoSession session = new MongoSession(sessionWrapper.getString((Object)ID), maxIntervalDuration.getSeconds());
        Object creationTime = sessionWrapper.get((Object)CREATION_TIME);
        if (creationTime instanceof Instant) {
            session.setCreationTime(((Instant)creationTime).toEpochMilli());
        } else if (creationTime instanceof Date) {
            session.setCreationTime(((Date)creationTime).getTime());
        }
        Object lastAccessedTime = sessionWrapper.get((Object)LAST_ACCESSED_TIME);
        if (lastAccessedTime instanceof Instant) {
            session.setLastAccessedTime((Instant)lastAccessedTime);
        } else if (lastAccessedTime instanceof Date) {
            session.setLastAccessedTime(Instant.ofEpochMilli(((Date)lastAccessedTime).getTime()));
        }
        session.setExpireAt((Date)sessionWrapper.get((Object)"expireAt"));
        this.deserializeAttributes(sessionWrapper, session);
        return session;
    }

    private byte[] serializeAttributes(Session session) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (String attrName : session.getAttributeNames()) {
            attributes.put(attrName, session.getAttribute(attrName));
        }
        return (byte[])this.serializer.convert(attributes);
    }

    private void deserializeAttributes(Document sessionWrapper, Session session) {
        Object sessionAttributes = sessionWrapper.get((Object)ATTRIBUTES);
        byte[] attributesBytes = sessionAttributes instanceof Binary ? ((Binary)sessionAttributes).getData() : (byte[])sessionAttributes;
        Map attributes = (Map)this.deserializer.convert((Object)attributesBytes);
        for (Map.Entry entry : attributes.entrySet()) {
            session.setAttribute((String)entry.getKey(), entry.getValue());
        }
    }
}

