/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.jackson;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.jspecify.annotations.Nullable;
import org.springframework.security.web.webauthn.api.AuthenticatorTransport;

class AuthenticatorTransportDeserializer
extends StdDeserializer<AuthenticatorTransport> {
    AuthenticatorTransportDeserializer() {
        super(AuthenticatorTransport.class);
    }

    public @Nullable AuthenticatorTransport deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JacksonException {
        String transportValue = (String)parser.readValueAs(String.class);
        for (AuthenticatorTransport transport : AuthenticatorTransport.values()) {
            if (!transport.getValue().equals(transportValue)) continue;
            return transport;
        }
        return null;
    }
}

