/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.api;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.security.web.webauthn.api.AttestationConveyancePreference;
import org.springframework.security.web.webauthn.api.AuthenticationExtensionsClientInputs;
import org.springframework.security.web.webauthn.api.AuthenticatorSelectionCriteria;
import org.springframework.security.web.webauthn.api.Bytes;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialDescriptor;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialParameters;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialRpEntity;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialUserEntity;

public final class PublicKeyCredentialCreationOptions {
    private final PublicKeyCredentialRpEntity rp;
    private final PublicKeyCredentialUserEntity user;
    private final Bytes challenge;
    private final List<PublicKeyCredentialParameters> pubKeyCredParams;
    private final @Nullable Duration timeout;
    private final List<PublicKeyCredentialDescriptor> excludeCredentials;
    private final AuthenticatorSelectionCriteria authenticatorSelection;
    private final @Nullable AttestationConveyancePreference attestation;
    private final @Nullable AuthenticationExtensionsClientInputs extensions;

    private PublicKeyCredentialCreationOptions(PublicKeyCredentialRpEntity rp, PublicKeyCredentialUserEntity user, Bytes challenge, List<PublicKeyCredentialParameters> pubKeyCredParams, @Nullable Duration timeout, List<PublicKeyCredentialDescriptor> excludeCredentials, AuthenticatorSelectionCriteria authenticatorSelection, @Nullable AttestationConveyancePreference attestation, @Nullable AuthenticationExtensionsClientInputs extensions) {
        this.rp = rp;
        this.user = user;
        this.challenge = challenge;
        this.pubKeyCredParams = pubKeyCredParams;
        this.timeout = timeout;
        this.excludeCredentials = excludeCredentials;
        this.authenticatorSelection = authenticatorSelection;
        this.attestation = attestation;
        this.extensions = extensions;
    }

    public PublicKeyCredentialRpEntity getRp() {
        return this.rp;
    }

    public PublicKeyCredentialUserEntity getUser() {
        return this.user;
    }

    public Bytes getChallenge() {
        return this.challenge;
    }

    public List<PublicKeyCredentialParameters> getPubKeyCredParams() {
        return this.pubKeyCredParams;
    }

    public @Nullable Duration getTimeout() {
        return this.timeout;
    }

    public List<PublicKeyCredentialDescriptor> getExcludeCredentials() {
        return this.excludeCredentials;
    }

    public AuthenticatorSelectionCriteria getAuthenticatorSelection() {
        return this.authenticatorSelection;
    }

    public @Nullable AttestationConveyancePreference getAttestation() {
        return this.attestation;
    }

    public @Nullable AuthenticationExtensionsClientInputs getExtensions() {
        return this.extensions;
    }

    public static PublicKeyCredentialCreationOptionsBuilder builder() {
        return new PublicKeyCredentialCreationOptionsBuilder();
    }

    public static final class PublicKeyCredentialCreationOptionsBuilder {
        private PublicKeyCredentialRpEntity rp;
        private PublicKeyCredentialUserEntity user;
        private Bytes challenge;
        private List<PublicKeyCredentialParameters> pubKeyCredParams = new ArrayList<PublicKeyCredentialParameters>();
        private @Nullable Duration timeout;
        private List<PublicKeyCredentialDescriptor> excludeCredentials = new ArrayList<PublicKeyCredentialDescriptor>();
        private AuthenticatorSelectionCriteria authenticatorSelection;
        private @Nullable AttestationConveyancePreference attestation;
        private @Nullable AuthenticationExtensionsClientInputs extensions;

        private PublicKeyCredentialCreationOptionsBuilder() {
        }

        public PublicKeyCredentialCreationOptionsBuilder rp(PublicKeyCredentialRpEntity rp) {
            this.rp = rp;
            return this;
        }

        public PublicKeyCredentialCreationOptionsBuilder user(PublicKeyCredentialUserEntity user) {
            this.user = user;
            return this;
        }

        public PublicKeyCredentialCreationOptionsBuilder challenge(Bytes challenge) {
            this.challenge = challenge;
            return this;
        }

        public PublicKeyCredentialCreationOptionsBuilder pubKeyCredParams(PublicKeyCredentialParameters ... pubKeyCredParams) {
            return this.pubKeyCredParams(Arrays.asList(pubKeyCredParams));
        }

        public PublicKeyCredentialCreationOptionsBuilder pubKeyCredParams(List<PublicKeyCredentialParameters> pubKeyCredParams) {
            this.pubKeyCredParams = pubKeyCredParams;
            return this;
        }

        public PublicKeyCredentialCreationOptionsBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public PublicKeyCredentialCreationOptionsBuilder excludeCredentials(List<PublicKeyCredentialDescriptor> excludeCredentials) {
            this.excludeCredentials = excludeCredentials;
            return this;
        }

        public PublicKeyCredentialCreationOptionsBuilder authenticatorSelection(AuthenticatorSelectionCriteria authenticatorSelection) {
            this.authenticatorSelection = authenticatorSelection;
            return this;
        }

        public PublicKeyCredentialCreationOptionsBuilder attestation(AttestationConveyancePreference attestation) {
            this.attestation = attestation;
            return this;
        }

        public PublicKeyCredentialCreationOptionsBuilder extensions(AuthenticationExtensionsClientInputs extensions) {
            this.extensions = extensions;
            return this;
        }

        public PublicKeyCredentialCreationOptionsBuilder customize(Consumer<PublicKeyCredentialCreationOptionsBuilder> customizer) {
            customizer.accept(this);
            return this;
        }

        public PublicKeyCredentialCreationOptions build() {
            return new PublicKeyCredentialCreationOptions(this.rp, this.user, this.challenge, this.pubKeyCredParams, this.timeout, this.excludeCredentials, this.authenticatorSelection, this.attestation, this.extensions);
        }
    }
}

