/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.header.writers;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.jspecify.annotations.Nullable;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.util.Assert;

public final class CrossOriginResourcePolicyHeaderWriter
implements HeaderWriter {
    private static final String RESOURCE_POLICY = "Cross-Origin-Resource-Policy";
    private @Nullable CrossOriginResourcePolicy policy;

    public void setPolicy(CrossOriginResourcePolicy resourcePolicy) {
        Assert.notNull((Object)((Object)resourcePolicy), (String)"resourcePolicy cannot be null");
        this.policy = resourcePolicy;
    }

    @Override
    public void writeHeaders(HttpServletRequest request, HttpServletResponse response) {
        if (this.policy != null && !response.containsHeader(RESOURCE_POLICY)) {
            response.addHeader(RESOURCE_POLICY, this.policy.getPolicy());
        }
    }

    public static enum CrossOriginResourcePolicy {
        SAME_SITE("same-site"),
        SAME_ORIGIN("same-origin"),
        CROSS_ORIGIN("cross-origin");

        private final String policy;

        private CrossOriginResourcePolicy(String policy) {
            this.policy = policy;
        }

        public String getPolicy() {
            return this.policy;
        }

        public static @Nullable CrossOriginResourcePolicy from(String resourcePolicy) {
            for (CrossOriginResourcePolicy policy : CrossOriginResourcePolicy.values()) {
                if (!policy.getPolicy().equals(resourcePolicy)) continue;
                return policy;
            }
            return null;
        }
    }
}

