/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.csrf;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.DeferredCsrfToken;

final class RepositoryDeferredCsrfToken
implements DeferredCsrfToken {
    private final CsrfTokenRepository csrfTokenRepository;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private @Nullable CsrfToken csrfToken;
    private boolean missingToken;

    RepositoryDeferredCsrfToken(CsrfTokenRepository csrfTokenRepository, HttpServletRequest request, HttpServletResponse response) {
        this.csrfTokenRepository = csrfTokenRepository;
        this.request = request;
        this.response = response;
    }

    @Override
    public CsrfToken get() {
        this.init();
        return Objects.requireNonNull(this.csrfToken);
    }

    @Override
    public boolean isGenerated() {
        this.init();
        return this.missingToken;
    }

    private void init() {
        if (this.csrfToken != null) {
            return;
        }
        this.csrfToken = this.csrfTokenRepository.loadToken(this.request);
        boolean bl = this.missingToken = this.csrfToken == null;
        if (this.missingToken) {
            this.csrfToken = this.csrfTokenRepository.generateToken(this.request);
            this.csrfTokenRepository.saveToken(this.csrfToken, this.request, this.response);
        }
    }
}

