/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server;

import java.util.Arrays;
import java.util.List;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.server.handler.DefaultWebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class WebFilterChainProxy
implements WebFilter {
    private final List<SecurityWebFilterChain> filters;

    public WebFilterChainProxy(List<SecurityWebFilterChain> filters) {
        this.filters = filters;
    }

    public WebFilterChainProxy(SecurityWebFilterChain ... filters) {
        this.filters = Arrays.asList(filters);
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return Flux.fromIterable(this.filters).filterWhen(securityWebFilterChain -> securityWebFilterChain.matches(exchange)).next().switchIfEmpty(chain.filter(exchange).then(Mono.empty())).flatMap(securityWebFilterChain -> securityWebFilterChain.getWebFilters().collectList()).map(filters -> new DefaultWebFilterChain(arg_0 -> ((WebFilterChain)chain).filter(arg_0), filters)).flatMap(securedChain -> securedChain.filter(exchange));
    }
}

