/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DelegatingAccessDeniedHandler
implements AccessDeniedHandler {
    private final LinkedHashMap<Class<? extends AccessDeniedException>, AccessDeniedHandler> handlers;
    private final AccessDeniedHandler defaultHander;

    public DelegatingAccessDeniedHandler(LinkedHashMap<Class<? extends AccessDeniedException>, AccessDeniedHandler> handlers, AccessDeniedHandler defaultHander) {
        Assert.notEmpty(handlers, (String)"handlers cannot be null or empty");
        Assert.notNull((Object)defaultHander, (String)"defaultHandler cannot be null");
        this.handlers = handlers;
        this.defaultHander = defaultHander;
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        for (Map.Entry<Class<? extends AccessDeniedException>, AccessDeniedHandler> entry : this.handlers.entrySet()) {
            Class<? extends AccessDeniedException> handlerClass = entry.getKey();
            if (!handlerClass.isAssignableFrom(accessDeniedException.getClass())) continue;
            AccessDeniedHandler handler = entry.getValue();
            handler.handle(request, response, accessDeniedException);
            return;
        }
        this.defaultHander.handle(request, response, accessDeniedException);
    }
}

