/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import java.util.Collection;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.AuthenticatedPrincipal;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public class Saml2Authentication
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 405897702378720477L;
    private final Object principal;
    private final String saml2Response;

    public Saml2Authentication(AuthenticatedPrincipal principal, String saml2Response, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        Assert.notNull((Object)principal, (String)"principal cannot be null");
        Assert.hasText((String)saml2Response, (String)"saml2Response cannot be null");
        this.principal = principal;
        this.saml2Response = saml2Response;
        this.setAuthenticated(true);
    }

    public Saml2Authentication(Object principal, String saml2Response, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.principal = principal;
        this.saml2Response = saml2Response;
        this.setAuthenticated(true);
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public String getSaml2Response() {
        return this.saml2Response;
    }

    public Object getCredentials() {
        return this.getSaml2Response();
    }
}

