/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication.logout;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public final class Saml2LogoutRequest
implements Serializable {
    private static final long serialVersionUID = -3588981995674761337L;
    private static final Function<Map<String, String>, String> DEFAULT_ENCODER = params -> {
        if (params.isEmpty()) {
            return null;
        }
        UriComponentsBuilder builder = UriComponentsBuilder.newInstance();
        for (Map.Entry component : params.entrySet()) {
            builder.queryParam((String)component.getKey(), new Object[]{UriUtils.encode((String)((String)component.getValue()), (Charset)StandardCharsets.ISO_8859_1)});
        }
        return builder.build(true).toString().substring(1);
    };
    private final String location;
    private final Saml2MessageBinding binding;
    private final Map<String, String> parameters;
    private final String id;
    private final String relyingPartyRegistrationId;
    private transient Function<Map<String, String>, String> encoder;

    private Saml2LogoutRequest(String location, Saml2MessageBinding binding, Map<String, String> parameters, String id, String relyingPartyRegistrationId) {
        this(location, binding, parameters, id, relyingPartyRegistrationId, DEFAULT_ENCODER);
    }

    private Saml2LogoutRequest(String location, Saml2MessageBinding binding, Map<String, String> parameters, String id, String relyingPartyRegistrationId, Function<Map<String, String>, String> encoder) {
        this.location = location;
        this.binding = binding;
        this.parameters = Collections.unmodifiableMap(new LinkedHashMap<String, String>(parameters));
        this.id = id;
        this.relyingPartyRegistrationId = relyingPartyRegistrationId;
        this.encoder = encoder;
    }

    public String getId() {
        return this.id;
    }

    public String getLocation() {
        return this.location;
    }

    public Saml2MessageBinding getBinding() {
        return this.binding;
    }

    public String getSamlRequest() {
        return this.parameters.get("SAMLRequest");
    }

    public String getRelayState() {
        return this.parameters.get("RelayState");
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getParametersQuery() {
        return this.encoder.apply(this.parameters);
    }

    public String getRelyingPartyRegistrationId() {
        return this.relyingPartyRegistrationId;
    }

    public static Builder withRelyingPartyRegistration(RelyingPartyRegistration registration) {
        return new Builder(registration);
    }

    public static final class Builder {
        private final RelyingPartyRegistration registration;
        private String location;
        private Saml2MessageBinding binding;
        private Map<String, String> parameters = new LinkedHashMap<String, String>();
        private Function<Map<String, String>, String> encoder = DEFAULT_ENCODER;
        private String id;

        private Builder(RelyingPartyRegistration registration) {
            this.registration = registration;
            this.location = registration.getAssertingPartyMetadata().getSingleLogoutServiceLocation();
            this.binding = registration.getAssertingPartyMetadata().getSingleLogoutServiceBinding();
        }

        public Builder samlRequest(String samlRequest) {
            this.parameters.put("SAMLRequest", samlRequest);
            return this;
        }

        public Builder binding(Saml2MessageBinding binding) {
            this.binding = binding;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder relayState(String relayState) {
            this.parameters.put("RelayState", relayState);
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder parameters(Consumer<Map<String, String>> parametersConsumer) {
            parametersConsumer.accept(this.parameters);
            return this;
        }

        public Builder parametersQuery(Function<Map<String, String>, String> encoder) {
            this.encoder = encoder;
            return this;
        }

        public Saml2LogoutRequest build() {
            return new Saml2LogoutRequest(this.location, this.binding, this.parameters, this.id, this.registration.getRegistrationId(), this.encoder);
        }
    }
}

